(function(){
  const el = wp.element.createElement;
  const { useState } = wp.element;
  const { TextControl, Button, SelectControl, Notice } = wp.components;

  function App(){
    const [topic, setTopic] = useState('');
    const [type, setType] = useState('blog');
    const [out, setOut] = useState(null);
    const [msg, setMsg] = useState('');

    async function generate(){
      setMsg('Generating…');
      try {
        const r = await wp.apiFetch({
          path: '/miro/v1/post/generate',
          method: 'POST',
          data: { topic, type },
          headers: { 'X-WP-Nonce': MiroAI.nonce }
        });
        setOut(r);
        setMsg('Generated.');
      } catch(e){
        setMsg('Failed: ' + (e.message||e));
      }
    }

    function renderOut(){
      if (!out) return null;
      return el('div', { style:{marginTop:'12px'} },
        el('h3', null, out.title || 'Draft'),
        el('code', null, out.slug || ''),
        el('div', { dangerouslySetInnerHTML: { __html: out.body_html || '' } })
      );
    }

    return el('div', null,
      msg ? el(Notice, { status:'info', onRemove: ()=>setMsg('') }, msg) : null,
      el(TextControl, { label:'Topic', value: topic, onChange: setTopic, placeholder:'e.g. Best free SEO plugins' }),
      el(SelectControl, { label:'Type', value: type, options:[
        {label:'Blog', value:'blog'},
        {label:'News', value:'news'},
        {label:'Review', value:'review'},
        {label:'Listicle', value:'list'},
        {label:'Product', value:'product'}
      ], onChange: setType }),
      el(Button, { variant:'primary', onClick: generate, disabled: !topic }, 'Generate With AI'),
      renderOut()
    );
  }

  const mount = document.getElementById('miro-admin-app');
  if (mount) wp.element.render(el(App), mount);
})();