jQuery(function ($) {

    function buildFAQHTML(faqs) {
        let html = '<h2>Frequently Asked Questions</h2>';
        html += '<div class="miro-faq">';
        faqs.forEach(f => {
            html += `
            <div class="miro-faq-item">
                <h3>${f.q}</h3>
                <p>${f.a}</p>
            </div>`;
        });
        html += '</div>';
        return html;
    }

    // UI Box
    $("#miro-ai-faq-classic").html(`
        <button type="button" class="button button-primary" id="miroFaqGenerate">Generate FAQ</button>
        <div id="miroFaqLoading" style="margin-top:10px;display:none;">Generating…</div>
        <div id="miroFaqOutput" style="margin-top:15px;"></div>
    `);

    $("#miroFaqGenerate").on("click", function (e) {
        e.preventDefault();
        e.stopPropagation();

        $("#miroFaqLoading").show();
        $("#miroFaqOutput").html("");

        // Get post ID (try all sources)
        let post_id = 0;
        if ($("#post_ID").length && $("#post_ID").val()) {
            post_id = parseInt($("#post_ID").val(), 10) || 0;
        }
        if (!post_id && typeof wp !== 'undefined' && wp.data && wp.data.select('core/editor')) {
            post_id = wp.data.select('core/editor').getCurrentPostId() || 0;
        }
        if (!post_id && typeof MiroFAQ !== 'undefined' && MiroFAQ.post_id) {
            post_id = parseInt(MiroFAQ.post_id, 10) || 0;
        }
        if (!post_id && $("#miro-ai-faq-classic").data("post-id")) {
            post_id = parseInt($("#miro-ai-faq-classic").data("post-id"), 10) || 0;
        }

        // Get title: try editor first, then fall back to saved title from server
        let title = '';

        // 1. Block Editor (Gutenberg) – current edited title
        if (typeof wp !== 'undefined' && wp.data && wp.data.select('core/editor')) {
            try {
                title = wp.data.select('core/editor').getEditedPostAttribute('title') || '';
            } catch (e) {}
        }

        // 2. Classic Editor – #title input
        if (!title && $("#title").length) {
            title = $("#title").val() || '';
        }

        // 3. Any visible input with "title" in id or name
        if (!title && $('input[name="post_title"]').length) {
            title = $('input[name="post_title"]').val() || '';
        }
        if (!title && $("input[id*='title']").length) {
            title = $("input[id*='title']").first().val() || '';
        }

        // 4. Gutenberg title in DOM (contenteditable)
        if (!title && document.querySelector('.editor-post-title__input')) {
            var el = document.querySelector('.editor-post-title__input');
            title = (el.innerText || el.textContent || '').trim();
        }

        // 5. Saved title from server (PHP – always available when editing a draft/post)
        if (!title && typeof MiroFAQ !== 'undefined' && MiroFAQ.saved_title) {
            title = MiroFAQ.saved_title;
        }
        if (!title && $("#miro-ai-faq-classic").data("saved-title")) {
            title = $("#miro-ai-faq-classic").data("saved-title") || '';
        }

        title = (title || '').trim();

        // Get content
        let content = '';
        if (typeof tinyMCE !== 'undefined' && tinyMCE.activeEditor) {
            content = tinyMCE.activeEditor.getContent();
        } else if ($("#content").length) {
            content = $("#content").val();
        } else if (typeof wp !== 'undefined' && wp.data && wp.data.select('core/editor')) {
            try {
                content = wp.data.select('core/editor').getEditedPostAttribute('content') || '';
            } catch (e) {}
        }

        // Validate: must have a title (from editor or saved)
        if (!title) {
            $("#miroFaqLoading").hide();
            $("#miroFaqOutput").html('<p style="color:red;"><strong>Error:</strong> Please enter a post title first.</p>');
            return;
        }

        fetch(MiroFAQ.rest, {
            method: "POST",
            headers: {
                "Content-Type": "application/json",
                "X-WP-Nonce": MiroFAQ.nonce
            },
            body: JSON.stringify({ post_id, title, content })
        })
            .then(r => r.json())
            .then(j => {
                $("#miroFaqLoading").hide();

                // Check for WordPress REST API error
                if (j.code && j.message) {
                    $("#miroFaqOutput").html(`<p style="color:red;"><strong>Error:</strong> ${j.message}</p>`);
                    return;
                }

                if (!j.faqs) {
                    $("#miroFaqOutput").html("<p>No FAQ returned.</p>");
                    return;
                }

                let html = "<h4>Preview</h4>";
                j.faqs.forEach(f => {
                    html += `<p><strong>Q:</strong> ${f.q}<br><strong>A:</strong> ${f.a}</p>`;
                });

                // Insert button
                html += `<button type="button" class="button button-secondary" id="miroFaqInsert">Insert FAQ into Post</button>`;

                $("#miroFaqOutput").html(html);

                $("#miroFaqInsert").on("click", function (e) {
                    e.preventDefault();
                    e.stopPropagation();

                    const blockHTML = buildFAQHTML(j.faqs);

                    // Classic editor insert
                    if (tinyMCE.activeEditor) {
                        tinyMCE.activeEditor.execCommand(
                            "mceInsertContent",
                            false,
                            blockHTML
                        );
                    } else {
                        $("#content").val($("#content").val() + blockHTML);
                    }
                });
            })
            .catch(err => {
                $("#miroFaqLoading").hide();
                $("#miroFaqOutput").html(`<p style="color:red;"><strong>Error:</strong> ${err.message}</p>`);
                console.error('FAQ Generation Error:', err);
            });
    });
});
