(function($){
  function log(msg){
    const box = $('#miro-altfix-log');
    if (!box.length) return;
    box.append($('<div/>').text(String(msg)));
    box.scrollTop(box[0].scrollHeight);
  }

  async function postJSON(url, data){
    if (window.wp && wp.apiFetch) {
      return await wp.apiFetch({
        url, method: 'POST',
        headers: { 'X-WP-Nonce': MiroAltFix.nonce },
        data
      });
    }
    const res = await fetch(url, {
      method: 'POST',
      headers: {
        'X-WP-Nonce': MiroAltFix.nonce,
        'Content-Type': 'application/json'
      },
      body: JSON.stringify(data)
    });
    if (!res.ok) {
      const t = await res.text();
      throw new Error('HTTP ' + res.status + ' ' + t);
    }
    return await res.json();
  }

  async function runPage(page){
    const postType = $('#miro-altfix-posttype').val() || 'post';
    const mode = $('input[name="miro-altfix-mode"]:checked').val() || 'fill';
    const setTitle = $('#miro-altfix-settitle').is(':checked');
    const includeFeatured = $('#miro-altfix-includefeat').is(':checked');
    const applyTo = $('input[name="miro-altfix-applyto"]:checked').val() || 'content';

    const payload = {
      post_type: postType,
      mode,
      set_title: setTitle,
      include_featured: includeFeatured,
      apply_to: applyTo,
      page: page || 1
    };

    log('→ Running batch page ' + payload.page + ' …');

    const res = await postJSON(MiroAltFix.restURL, payload);

    (res.messages || []).forEach(m => log(m));
    log('Batch summary: posts=' + res.processed_posts + ', alt_changed=' + res.alt_changed);

    if (res.done) {
      log('✅ Completed.');
      $('#miro-altfix-start').prop('disabled', false).text('Scan & Fix');
      return;
    }
    await runPage(res.next_page || (payload.page + 1));
  }

  $(document).on('click', '#miro-altfix-start', async function(){
    $('#miro-altfix-log').empty();
    $(this).prop('disabled', true).text('Working…');
    try {
      if (!window.MiroAltFix || !MiroAltFix.restURL) {
        throw new Error('MiroAltFix.restURL missing — script not localized or wrong handle');
      }
      await runPage(1);
    } catch (e) {
      log('❌ Error: ' + (e && e.message ? e.message : String(e)));
      $('#miro-altfix-start').prop('disabled', false).text('Scan & Fix');
      alert('ALT Fix error — check log box.');
    }
  });
})(jQuery);
