jQuery(function($){
  // ===== debounce & helpers =====
  var debounceTimer = null;
  function debounce(fn, ms){
    clearTimeout(debounceTimer);
    debounceTimer = setTimeout(fn, ms);
  }

  function getContent(){
    if (typeof tinyMCE !== 'undefined' && tinyMCE.activeEditor && !tinyMCE.activeEditor.isHidden()) {
      return tinyMCE.activeEditor.getContent();
    }
    return $('#content').val() || '';
  }

  // --- REST helpers that ALWAYS send the WP REST nonce (prevents 401) ---
  function apiGet(path){
    return $.ajax({
      url: MiroAIClassic.rest + path,
      method: 'GET',
      beforeSend: function(xhr){ xhr.setRequestHeader('X-WP-Nonce', MiroAIClassic.nonce); }
    });
  }
  function apiPost(path, dataObj){
    return $.ajax({
      url: MiroAIClassic.rest + path,
      method: 'POST',
      data: JSON.stringify(dataObj || {}),
      contentType: 'application/json',
      beforeSend: function(xhr){ xhr.setRequestHeader('X-WP-Nonce', MiroAIClassic.nonce); }
    });
  }

  // ===== Apply Fix with AI for specific issues =====
  function applyFix(issueId){
    var title = $('#title').val() || '';
    var slug = $('#post_name').val() || '';
    var kw = $('#miro_focus_keyword').val() || '';
    var excerpt = $('#excerpt').val() || '';
    var content = getContent();
    $.ajax({
      url: MiroAIClassic.rest + 'seo/fix',
      method: 'POST',
      data: JSON.stringify({ issue: issueId, title, slug, focus_keyword: kw, meta_desc: excerpt, content }),
      contentType: 'application/json',
      beforeSend: function(xhr){ xhr.setRequestHeader('X-WP-Nonce', MiroAIClassic.nonce); },
      success: function(r){
        if (r.title) $('#title').val(r.title);
        if (r.meta_desc) $('#excerpt').val(r.meta_desc);
        if (r.slug) $('#post_name').val(r.slug);
        if (r.body_html) {
          if (typeof tinyMCE !== 'undefined' && tinyMCE.activeEditor && !tinyMCE.activeEditor.isHidden()) {
            tinyMCE.activeEditor.setContent(r.body_html);
          } else {
            $('#content').val(r.body_html);
          }
        }
      },
      error: function(err){
        var msg = (err && err.responseJSON && err.responseJSON.message) || 'Fix failed';
        alert(msg);
      }
    });
  }


  // ===== Generate full draft (title/meta/body) =====
  function generateFull() {
    const kw = $('#miro_focus_keyword').val() || '';
    if (!kw) { alert('Set a Focus Keyword first.'); return; }

    $('#miro_check_now').prop('disabled', true).text('Generating…');
    $.ajax({
      url: MiroAIClassic.rest + 'ai/generate_full',
      method: 'POST',
      data: JSON.stringify({ focus_keyword: kw, length: 900 }),
      contentType: 'application/json',
      beforeSend: function(xhr){ xhr.setRequestHeader('X-WP-Nonce', MiroAIClassic.nonce); },
      success: function(r){
        $('#title').val(r.title).trigger('input');
        if ($('#post_name').length) { $('#post_name').val(r.slug).trigger('change'); }
        if ($('#excerpt').length) { $('#excerpt').val(r.meta_desc).trigger('input'); }
        if (typeof tinyMCE !== 'undefined' && tinyMCE.activeEditor && !tinyMCE.activeEditor.isHidden()) {
          tinyMCE.activeEditor.setContent(r.body_html);
        } else {
          $('#content').val(r.body_html);
        }
      },
      error: function(err){
        var msg = (err && err.responseJSON && err.responseJSON.message) ? err.responseJSON.message : 'Generate failed.';
        alert(msg);
      },
      complete: function(){
        $('#miro_check_now').prop('disabled', false).text('Generate It');
      }
    });
  }

  // ===== Internal Links (embeddings) — Classic metabox =====
  async function loadInternalLinks(){
    var postId = $('#post_ID').val();
    var inside = $('#miro-internal-links-content');
    if (!inside.length) return;

    inside.html('<em>Loading suggestions…</em>');
    try {
      let res = await apiGet('links/suggest?post_id=' + postId);
      if (!res.items || !res.items.length){
        // Build the current post’s embedding and retry once
        await apiPost('links/build_one', { post_id: postId });
        res = await apiGet('links/suggest?post_id=' + postId);
      }

      inside.empty();
      if (!res.items || !res.items.length){
        inside.append('<p>No suggestions yet (need at least a couple of published posts).</p>');
        return;
      }

      res.items.forEach(function(r){
        var row = $('<div style="margin:6px 0"></div>');
        row.append('<strong>'+r.title+'</strong><br><span style="font-size:11px;color:#666">'+r.url+' • conf '+r.confidence+'</span> ');
        var btn = $('<button type="button" class="button button-small">Insert at cursor</button>').on('click', function(){
          var sentence = ' See also: <a href="'+r.url+'">'+(r.suggestedAnchor||r.title)+'</a>.';
          if (typeof tinyMCE !== 'undefined' && tinyMCE.activeEditor && !tinyMCE.activeEditor.isHidden()) {
            tinyMCE.activeEditor.insertContent(sentence);
          } else {
            var cur = $('#content').val()||''; $('#content').val(cur + sentence);
          }
        });
        row.append(btn);
        inside.append(row);
      });
    } catch(e){
      inside.html('<p style="color:#c00">Failed to load suggestions (401/nonce). Refresh the page and try again.</p>');
    }
  }

  $('#miro_check_now').text('Generate It').off('click').on('click', generateFull);
  $('#miro_fix_ai').off('click').on('click', function(){
    const content = getContent();
    $.ajax({
      url: MiroAIClassic.rest + 'ai/rewrite',
      method: 'POST',
      data: JSON.stringify({ text: content, intent: 'improve-seo' }),
      contentType: 'application/json',
      beforeSend: function(xhr){ xhr.setRequestHeader('X-WP-Nonce', MiroAIClassic.nonce); },
      success: function(r){
        if (typeof tinyMCE !== 'undefined' && tinyMCE.activeEditor && !tinyMCE.activeEditor.isHidden()) tinyMCE.activeEditor.setContent(r.text);
        else $('#content').val(r.text);
      }
    });
  });

  // Load internal links after DOM ready
  loadInternalLinks();
});
