jQuery(function($){
  async function startSync(){
    try {
      const r = await fetch(MiroGSC.rest + 'gsc/sync/start', {
        method: 'POST',
        headers: {'X-WP-Nonce': MiroGSC.nonce}
      });
      const data = await r.json();
      if (!data.job_id) throw new Error('No job id');
      poll(data.job_id);
      $('#miro-gsc-status').text('Queued...');
    } catch(e) {
      $('#miro-gsc-status').text('Error: ' + e.message);
    }
  }

  async function poll(job){
    const iv = setInterval(async ()=>{
      try {
        const r = await fetch(MiroGSC.rest + 'gsc/sync/status?job=' + encodeURIComponent(job), {
          headers: {'X-WP-Nonce': MiroGSC.nonce}
        });
        const s = await r.json();
        $('#miro-gsc-status').text(
          (s.error ? ('Error: ' + s.error) : (s.step + ' — ' + (s.progress||0) + '%'))
        );
        if (s.done) clearInterval(iv);
      } catch (e) {}
    }, 3000);
  }

  $(document).on('click', '#miro-gsc-sync-btn', startSync);
});
