jQuery(function($){
  $(document).on('click', '.miro-index-check', function(e){
    e.preventDefault();
    var postId = $(this).data('post');
    var $msg = $('#miro-index-msg').text('Checking...');

    fetch(MiroIndex.rest + 'index/check', {
      method: 'POST',
      headers: {
        'X-WP-Nonce': MiroIndex.nonce,
        'Content-Type': 'application/json'
      },
      body: JSON.stringify({ post_id: postId })
    })
    .then(async (r) => {
      let data;
      try { data = await r.json(); } catch(e){ data = {}; }
      if (!r.ok) {
        const reason = data?.message || data?.details?.error || data?.details?.body || ('HTTP ' + r.status);
        throw new Error(reason);
      }
      return data;
    })
    .then((res) => {
      $msg.text('Status: ' + res.status);
      // refresh the badge/details quickly
      location.reload();
    })
    .catch((err) => {
      $msg.text('Error: ' + (err.message || 'Unknown'));
    });
  });

  $(document).on('click', '.miro-index-ping', function(e){
    e.preventDefault();
    var postId = $(this).data('post');
    var $msg = $('#miro-index-msg').text('Re-indexing...');

    fetch(MiroIndex.rest + 'index/ping', {
      method: 'POST',
      headers: {
        'X-WP-Nonce': MiroIndex.nonce,
        'Content-Type': 'application/json'
      },
      body: JSON.stringify({ post_id: postId })
    })
    .then(async (r)=>({ok:r.ok, status:r.status, data: await r.json().catch(()=>({}))}))
    .then(({ok, status, data})=>{
      if(!ok) throw new Error(data?.message || ('HTTP '+status));
      var acts = Array.isArray(data.actions) ? data.actions.join(', ') : '';
      $msg.text(acts ? ('Submitted: ' + acts) : 'Submitted.');
    })
    .catch((err)=> $msg.text('Error: ' + (err.message || 'Unknown')));
  });
});
