(function($){
  function esc(s){ return String(s ?? '').replace(/[&<>"']/g, m => ({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#039;'}[m])); }

  function postId(){
    return (window.MiroILPost && window.MiroILPost.id) ? parseInt(window.MiroILPost.id, 10) : 0;
  }

  async function api(path, opts){
    const url = (window.MiroIL && MiroIL.rest ? MiroIL.rest : '') + path;
    const headers = Object.assign(
      { 'X-WP-Nonce': (window.MiroIL ? MiroIL.nonce : '') },
      (opts && opts.headers ? opts.headers : {})
    );
    const res = await fetch(url, Object.assign({}, opts || {}, { headers }));
    return res.json();
  }

  function setNote(t){ $('#miro-il-note').text(t || ''); }
  function addLog(line){
    $('#miro-il-log').append('<div>• '+esc(line)+'</div>');
  }

  async function oneClick(){
    const id = postId();
    if (!id) return alert('Missing post id');
    const maxLinks = parseInt($('#miro-il-max').val(), 10) || 3;

    $('#miro-il-log').empty();
    setNote('Working…');

    try {
      const j = await api('ilink/one', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ post_id: id, max_links: maxLinks, pool: 90 })
      });

      if (j && j.error) { setNote(''); return alert(j.error); }

      setNote('Inserted '+(j.inserted||0)+' · Skipped '+(j.skipped||0));
      (j.notes || []).forEach(addLog);

      if ((j.inserted||0) > 0) {
        addLog('Saved. Refresh editor if you don’t see links yet.');
      }
    } catch(e){
      setNote('');
      alert('Auto-link failed');
    }
  }

  async function suggest(){
    const id = postId();
    if (!id) return alert('Missing post id');

    $('#miro-il-log').empty();
    setNote('Scanning…');

    try {
      const j = await api('ilink/suggest?post_id=' + encodeURIComponent(id), { method: 'GET' });
      if (j && j.error) { setNote(''); return alert(j.error); }

      const list = (j.matches || []);
      setNote('Found ' + list.length + ' targets');

      if (!list.length) {
        $('#miro-il-content').html('<em>No good anchors found in your content yet.</em>');
        return;
      }

      let html = '<ol style="margin:8px 0 0 18px">';
      list.slice(0, 30).forEach(m => {
        html += '<li><strong>'+esc(m.anchor)+'</strong> → <a href="'+esc(m.url)+'" target="_blank" rel="noopener">'+esc(m.target_title)+'</a></li>';
      });
      html += '</ol>';

      $('#miro-il-content').html(html);
    } catch(e){
      setNote('');
      alert('Suggest failed');
    }
  }

  $(document).on('click', '#miro-il-one', function(e){ e.preventDefault(); oneClick(); });
  $(document).on('click', '#miro-il-suggest', function(e){ e.preventDefault(); suggest(); });

})(jQuery);
