(function () {
    'use strict';

    var form = document.getElementById('miro-ai-post-gen-form');
    var submitBtn = document.getElementById('miro-apg-submit');
    var statusEl = document.getElementById('miro-apg-status');

    if (!form || !window.miroAiPostGen) return;

    function setStatus(text, type) {
        if (!statusEl) return;
        statusEl.textContent = text || '';
        statusEl.className = 'miro-apg-status' + (type ? ' ' + type : '');
    }

    form.addEventListener('submit', function (e) {
        e.preventDefault();

        var focusKeyword = (document.getElementById('miro-apg-focus-keyword') || {}).value;
        var topic = (document.getElementById('miro-apg-topic') || {}).value;
        var wordCount = (document.getElementById('miro-apg-word-count') || {}).value;

        if (!focusKeyword || !focusKeyword.trim()) {
            setStatus(window.miroAiPostGen.i18n && window.miroAiPostGen.i18n.error ? 'Focus keyword is required.' : 'Focus keyword is required.', 'error');
            return;
        }

        submitBtn.disabled = true;
        setStatus(window.miroAiPostGen.i18n.generating || 'Generating post…', 'loading');

        fetch(window.miroAiPostGen.rest, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-WP-Nonce': window.miroAiPostGen.nonce
            },
            body: JSON.stringify({
                focus_keyword: focusKeyword.trim(),
                topic: (topic || '').trim(),
                word_count: parseInt(wordCount, 10) || 1200
            })
        })
            .then(function (res) {
                return res.json().then(function (data) {
                    return { ok: res.ok, status: res.status, data: data };
                });
            })
            .then(function (result) {
                if (result.ok && result.data.ok && result.data.edit_link) {
                    setStatus('', '');
                    window.location.href = result.data.edit_link;
                    return;
                }
                var msg = (result.data && result.data.message) || (result.data && result.data.error) || window.miroAiPostGen.i18n.error || 'Generation failed.';
                setStatus(msg, 'error');
                submitBtn.disabled = false;
            })
            .catch(function (err) {
                setStatus(window.miroAiPostGen.i18n.error || 'Generation failed.', 'error');
                submitBtn.disabled = false;
            });
    });
})();
