(function(){
  const cfg = window.MIRO_INTENT_CFG || {};
  const restBase = cfg.restBase || '';
  const nonce = cfg.nonce || '';

  function call(endpoint, body) {
    return fetch(restBase + endpoint, {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
        'X-WP-Nonce': nonce
      },
      body: JSON.stringify(body || {})
    }).then(r => r.json());
  }

  function ready(fn){ if (document.readyState !== 'loading') fn(); else document.addEventListener('DOMContentLoaded', fn); }

  ready(function(){
    const box   = document.getElementById('miro_intent_result');
    const btn   = document.getElementById('miro_intent_check_btn');
    const patch = document.getElementById('miro_intent_patch_btn');
    if (!box || !btn) return;

    btn.addEventListener('click', async function(){
      const kw   = (document.getElementById('miro_intent_kw') || {}).value || '';
      const tit  = (document.getElementById('title') || {}).value || (document.getElementById('miro_intent__title')||{}).value || '';
      const cont = (document.getElementById('content') || {}).value || (document.getElementById('miro_intent__content')||{}).value || '';
      if (!kw || !tit || !cont) { box.textContent = 'Missing keyword/title/content.'; return; }
      box.textContent = 'Checking…';
      patch.style.display = 'none';

      try {
        const res = await call('intent/check', { focus_keyword: kw, title: tit, content: cont });
        if (res.code) throw new Error(res.message || 'API error');
        box.innerHTML = `
          <div><strong>Expected:</strong> ${res.expected_intent}</div>
          <div><strong>Content:</strong> ${res.content_intent}</div>
          <div style="margin-top:6px;">${res.advice}</div>
        `;
        if (!res.match) {
          patch.style.display = '';
          patch.onclick = async function(){
            const patchRes = await call('intent/patch_intro', { focus_keyword: kw, target_intent: res.expected_intent, title: tit, content: cont });
            if (patchRes && patchRes.body_html) {
              // Put the patched body back to Classic editor
              const ta = document.getElementById('content');
              if (ta) ta.value = patchRes.body_html;
              box.innerHTML += '<div style="margin-top:6px;color:#2271b1;">Intro updated in the editor.</div>';
            }
          };
        }
      } catch (e) {
        box.textContent = e.message || 'Failed';
      }
    });
  });
})();
