(function(){
  const cfg = window.MIRO_ILX_ADMIN || {};
  const $ = (sel)=>document.querySelector(sel);

  const status = $("#miro-ilx-status");
  function setS(t){ if(status) status.textContent = t; }

  function restUrl(path, useFallback) {
    var q = path.indexOf('?');
    var pathPart = q >= 0 ? path.substring(0, q) : path;
    var queryPart = q >= 0 ? path.substring(q + 1) : '';
    if (useFallback && cfg.rest_fallback_base && cfg.rest_route_prefix) {
      var sep = cfg.rest_fallback_base.indexOf('?') >= 0 ? '&' : '?';
      return cfg.rest_fallback_base + sep + 'rest_route=' + encodeURIComponent(cfg.rest_route_prefix + pathPart) + (queryPart ? '&' + queryPart : '');
    }
    return (cfg.rest || '') + path;
  }
  function ajaxUrl(path, method, data) {
    var q = path.indexOf('?');
    var pathPart = q >= 0 ? path.substring(0, q) : path;
    var queryPart = q >= 0 ? path.substring(q + 1) : '';
    var actions = cfg.ajax_actions || {};
    var action = actions[pathPart];
    if (!cfg.ajaxurl || !action) return null;
    var url = cfg.ajaxurl + '?action=' + encodeURIComponent(action) + '&_wpnonce=' + encodeURIComponent(cfg.nonce);
    if (queryPart && (method || 'GET').toUpperCase() === 'GET') url += '&' + queryPart;
    return url;
  }
  async function api(path, method, data) {
    var pathPart = path.indexOf('?') >= 0 ? path.substring(0, path.indexOf('?')) : path;
    var methodUp = (method || 'GET').toUpperCase();
    var opt = { method: method || 'GET', headers: { 'X-WP-Nonce': cfg.nonce } };
    if (methodUp === 'POST') {
      opt.headers['Content-Type'] = 'application/json';
      opt.body = JSON.stringify(data || {});
    }
    var url, r, text, isHtml;
    // Try admin-ajax first (most reliable on all hosts)
    var ajaxTarget = ajaxUrl(path, method, data);
    if (ajaxTarget) {
      r = await fetch(ajaxTarget, opt);
      text = await r.text();
      isHtml = text && text.trim().charAt(0) === '<';
      if (r.ok && !isHtml) {
        try { return JSON.parse(text); } catch (e) { return { error: 'Invalid JSON' }; }
      }
      if (!r.ok && text && text.trim().charAt(0) !== '<') {
        try {
          var parsed = JSON.parse(text);
          if (parsed && typeof parsed.error === 'string') return { error: parsed.error };
        } catch (e) {}
      }
    }
    // Fallback: REST then REST fallback URL
    url = restUrl(path, false);
    r = await fetch(url, opt);
    text = await r.text();
    isHtml = text && text.trim().charAt(0) === '<';
    if (!r.ok || isHtml) {
      if (isHtml && cfg.rest_fallback_base && cfg.rest_route_prefix) {
        url = restUrl(path, true);
        r = await fetch(url, opt);
        text = await r.text();
      }
      if (!r.ok || (text && text.trim().charAt(0) === '<')) {
        if (!r.ok && text && text.trim().charAt(0) !== '<') {
          try {
            var p = JSON.parse(text);
            if (p && typeof p.error === 'string') return { error: p.error };
          } catch (e) {}
        }
        return { error: r.ok ? 'Invalid response (expected JSON).' : (r.status + ' ' + r.statusText) };
      }
    }
    try { return JSON.parse(text); } catch (e) { return { error: 'Invalid JSON' }; }
  }

  function esc(s){ return String(s||"").replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;"); }

  function cardGrid(stats){
    const s = stats || {};
    return (
      "<div class='ilx-kpi-grid'>" +
        "<div class='ilx-kpi'><div class='ilx-kpi-label'>Indexed posts</div><div class='ilx-kpi-val'>"+(s.indexed||0)+"</div></div>" +
        "<div class='ilx-kpi'><div class='ilx-kpi-label'>Edges (internal links)</div><div class='ilx-kpi-val'>"+(s.edges||0)+"</div></div>" +
        "<div class='ilx-kpi'><div class='ilx-kpi-label'>Orphans</div><div class='ilx-kpi-val'>"+(s.orphans||0)+"</div></div>" +
        "<div class='ilx-kpi'><div class='ilx-kpi-label'>Last index</div><div class='ilx-kpi-sub'>"+(s.last_index||"—")+"</div></div>" +
      "</div>"
    );
  }

  async function stats(){
    setS("Loading stats…");
    const j = await api("ilinks/stats","GET");
    if(j && j.error){ setS("Error: "+j.error); return; }
    $("#miro-ilx-stats-box").innerHTML = cardGrid(j);
    setS("Ready");
  }

  async function buildIndex(){
    setS("Building index…");
    $("#miro-ilx-stats-box").innerHTML = "<em>Indexing…</em>";
    let offset = 0, per = 20;

    while(true){
      const j = await api("ilinks/index/build","POST",{offset:offset, per_page:per});
      if(j && j.error){ setS("Error: "+j.error); return; }
      setS((j.step||"Indexing")+" — "+(j.progress||0)+"%");
      if(j.done) break;
      offset += per;
      await new Promise(r=>setTimeout(r, 200));
    }
    setS("Index done");
    await stats();
  }

  async function buildGraph(){
    setS("Building link graph…");
    let offset = 0, per = 15;

    while(true){
      const j = await api("ilinks/graph/build","POST",{offset:offset, per_page:per});
      if(j && j.error){ setS("Error: "+j.error); return; }
      setS((j.step||"Graph")+" — "+(j.progress||0)+"%");
      if(j.done) break;
      offset += per;
      await new Promise(r=>setTimeout(r, 250));
    }
    setS("Graph done");
    await stats();
  }

  async function orphans(){
    $("#miro-ilx-orphans-note").textContent = "Loading…";
    const j = await api("ilinks/orphans?per_page=50&page=1","GET");
    if(j && j.error){ $("#miro-ilx-orphans-note").textContent = "Error: "+j.error; return; }

    const rows = j.rows || [];
    $("#miro-ilx-orphans-note").textContent = rows.length ? ("Showing "+rows.length) : "None 🎉";

    if(!rows.length){ $("#miro-ilx-orphans").innerHTML = "<em>No orphan pages found.</em>"; return; }

    let html = "<table class='widefat striped'><thead><tr><th>Post</th><th class='miro-ilx-th-90'>Inbound</th><th class='miro-ilx-th-90'>Outbound</th><th class='miro-ilx-th-140'>Action</th></tr></thead><tbody>";
    rows.forEach(function(r){
      html += "<tr>";
      html += "<td><strong>"+esc(r.title)+"</strong><div class='description'>"+esc(r.url)+"</div></td>";
      html += "<td>"+(r.inbound||0)+"</td>";
      html += "<td>"+(r.outbound||0)+"</td>";
      html += "<td><a class='button' href='"+esc(r.edit_url)+"'>Open Editor</a></td>";
      html += "</tr>";
    });
    html += "</tbody></table>";
    $("#miro-ilx-orphans").innerHTML = html;
  }

  async function bulk(){
    $("#miro-ilx-bulk-note").textContent = "Scanning…";
    $("#miro-ilx-bulk").innerHTML = "<em>Scanning…</em>";
    const j = await api("ilinks/bulk/scan","POST",{limit:20});
    if(j && j.error){ $("#miro-ilx-bulk-note").textContent = "Error: "+j.error; return; }

    const rows = j.rows || [];
    $("#miro-ilx-bulk-note").textContent = "Done. Showing "+rows.length;

    if(!rows.length){ $("#miro-ilx-bulk").innerHTML = "<em>No posts found.</em>"; return; }

    let html = "<table class='widefat striped'><thead><tr><th>Post</th><th class='miro-ilx-th-90'>Inbound</th><th class='miro-ilx-th-90'>Outbound</th><th class='miro-ilx-th-140'>Context hits</th><th class='miro-ilx-th-140'>Fallback hits</th><th class='miro-ilx-th-140'>Action</th></tr></thead><tbody>";
    rows.forEach(function(r){
      html += "<tr>";
      html += "<td><strong>"+esc(r.title)+"</strong><div class='description'>"+esc(r.url)+"</div></td>";
      html += "<td>"+(r.inbound||0)+"</td>";
      html += "<td>"+(r.outbound||0)+"</td>";
      html += "<td><strong>"+(r.contextual||0)+"</strong></td>";
      html += "<td>"+(r.closest||0)+"</td>";
      html += "<td><a class='button button-primary' href='"+esc(r.edit_url)+"'>Fix Now</a></td>";
      html += "</tr>";
    });
    html += "</tbody></table>";
    $("#miro-ilx-bulk").innerHTML = html;
  }

  document.getElementById("miro-ilx-stats").addEventListener("click", function(e){ e.preventDefault(); stats(); });
  document.getElementById("miro-ilx-build-index").addEventListener("click", function(e){ e.preventDefault(); buildIndex(); });
  document.getElementById("miro-ilx-build-graph").addEventListener("click", function(e){ e.preventDefault(); buildGraph(); });
  document.getElementById("miro-ilx-orphans-refresh").addEventListener("click", function(e){ e.preventDefault(); orphans(); });
  document.getElementById("miro-ilx-bulk-scan").addEventListener("click", function(e){ e.preventDefault(); bulk(); });

  stats();
  orphans();
})();


