(function ($) {
    'use strict';

    var $logoUrl = $('#miro-reports-logo-url');
    var $selectBtn = $('#miro-reports-select-logo');
    var $removeBtn = $('#miro-reports-remove-logo');
    var $preview = $('#miro-reports-logo-preview');

    function updatePreview(url) {
        if (url) {
            $preview.find('img').attr('src', url).one('error', function () {
                $preview.hide();
            });
            $preview.show();
            $removeBtn.show();
        } else {
            $preview.hide();
            $removeBtn.hide();
        }
    }

    $selectBtn.on('click', function () {
        var frame = wp.media({
            library: { type: 'image' },
            multiple: false
        });
        frame.on('select', function () {
            var att = frame.state().get('selection').first().toJSON();
            var url = att.url || '';
            $logoUrl.val(url);
            updatePreview(url);
        });
        frame.open();
    });

    $removeBtn.on('click', function () {
        $logoUrl.val('');
        updatePreview('');
    });
})(jQuery);
