(function ($) {
    'use strict';
    function openMediaPicker(inputSelector) {
        var input = $(inputSelector);
        if (!input.length || typeof wp === 'undefined' || !wp.media) return;
        var frame = wp.media({ library: { type: 'image' }, multiple: false });
        frame.on('select', function () {
            var att = frame.state().get('selection').first().toJSON();
            if (att && att.url) input.val(att.url);
        });
        frame.open();
    }
    $(document).on('click', '#miro-seo-hub-select-image', function () {
        openMediaPicker('#local_image');
    });
    $(document).on('click', '.miro-seo-hub-select-schema-image', function () {
        var id = $(this).data('target');
        if (id) openMediaPicker('#' + id);
    });

    /* Broken Links — scan via AJAX and show meter */
    $(document).on('submit', '#miro-broken-links-scan-form', function (e) {
        if (typeof miroBrokenLinks === 'undefined') return;
        e.preventDefault();
        var $form = $(this);
        var $meter = $('#miro-broken-links-scanning');
        var $btn = $('#miro-broken-links-scan-btn');
        $btn.prop('disabled', true);
        $meter.addClass('is-active').attr('aria-hidden', 'false');
        var data = {
            action: miroBrokenLinks.action,
            post_types: $form.find('input[name="post_types[]"]:checked').map(function () { return $(this).val(); }).get(),
            max_urls: $form.find('#broken_max_urls').val() || 40
        };
        data[miroBrokenLinks.nonceName] = miroBrokenLinks.nonce;
        $.ajax({
            url: miroBrokenLinks.ajaxUrl,
            type: 'POST',
            data: data,
            success: function (res) {
                if (res.success && res.data && res.data.redirect) {
                    window.location.href = res.data.redirect;
                    return;
                }
                $meter.removeClass('is-active').attr('aria-hidden', 'true');
                $btn.prop('disabled', false);
                alert(miroBrokenLinks.i18n.error || 'Scan failed.');
            },
            error: function () {
                $meter.removeClass('is-active').attr('aria-hidden', 'true');
                $btn.prop('disabled', false);
                alert(miroBrokenLinks.i18n.error || 'Scan failed.');
            }
        });
    });
})(jQuery);
