<?php
namespace Miro_AI_SEO;

if (!defined('ABSPATH')) exit;

class AI_Faq_UI {

    public static function init() {

        // Classic Editor
        add_action('add_meta_boxes', [__CLASS__, 'metabox']);
        add_action('admin_enqueue_scripts', [__CLASS__, 'classic_assets']);

        // Gutenberg
        add_action('enqueue_block_editor_assets', [__CLASS__, 'gutenberg_assets']);
    }

    public static function gutenberg_assets() {
        $file = MIRO_AI_SEO_DIR . 'assets/js/ai-faq.js';
        $ver = file_exists($file) ? filemtime($file) : MIRO_AI_SEO_VERSION;

        wp_enqueue_script(
            'miro-ai-faq',
            MIRO_AI_SEO_URL . 'assets/js/ai-faq.js',
            ['wp-plugins','wp-edit-post','wp-element','wp-components','wp-data'],
            $ver,
            true
        );

        wp_localize_script('miro-ai-faq', 'MiroFAQ', [
            'rest' => rest_url('miro/v1/ai/faq'),
            'nonce' => wp_create_nonce('wp_rest')
        ]);
    }

    public static function classic_assets($hook) {
        if (!in_array($hook, ['post.php','post-new.php'])) return;

        $file = MIRO_AI_SEO_DIR . 'assets/js/ai-faq-classic.js';
        $ver = file_exists($file) ? filemtime($file) : MIRO_AI_SEO_VERSION;

        wp_enqueue_script(
            'miro-ai-faq-classic',
            MIRO_AI_SEO_URL . 'assets/js/ai-faq-classic.js',
            ['jquery'],
            $ver,
            true
        );

        global $post;
        $saved_title = ($post && !empty($post->post_title)) ? $post->post_title : '';
        $post_id     = ($post && isset($post->ID)) ? (int) $post->ID : 0;

        wp_localize_script('miro-ai-faq-classic', 'MiroFAQ', [
            'rest'        => rest_url('miro/v1/ai/faq'),
            'nonce'       => wp_create_nonce('wp_rest'),
            'saved_title' => $saved_title,
            'post_id'     => $post_id
        ]);
    }

    public static function metabox() {
        add_meta_box(
            'miro_ai_faq_box',
            'Miro AI: FAQ Generator',
            [__CLASS__, 'metabox_html'],
            ['post','page'],
            'side',
            'high'
        );
    }

    public static function metabox_html($post) {
        $saved_title = $post && $post->post_title ? $post->post_title : '';
        $post_id     = $post ? (int) $post->ID : 0;
        echo '<div id="miro-ai-faq-classic" data-saved-title="' . esc_attr($saved_title) . '" data-post-id="' . esc_attr($post_id) . '"></div>';
    }
}
