<?php
namespace Miro_AI_SEO;

if (!defined('ABSPATH')) { exit; }

/**
 * Admin utilities: Full data reset (Danger Zone).
 */
class Miro_Admin_Utils {
    const RESET_ACTION = 'miro_suite_full_reset';

    public static function boot() {
        // Full reset is handled by Admin::handle_full_reset (single handler for admin_post_miro_suite_full_reset).
    }

    public static function handle_full_reset() {
        if (!current_user_can('manage_options')) wp_die(esc_html__('Forbidden', 'miro-ai-seo'), '', ['response' => 403]);
        check_admin_referer(self::RESET_ACTION);

        // --- Rank Tracker wipe ---
        self::reset_rank_tracker();
        // --- Index Monitor wipe ---
        self::reset_index_monitor();

        // Optional: clear settings from main settings page
        delete_option('miro_ai_openai_key');
        delete_option('miro_ai_gemini_key');
        delete_option('miro_ai_focus_language');

        // Back to Settings with success flag
        $to = admin_url('admin.php?page=miro-ai-settings');
        $to = add_query_arg('miro_reset_done', 1, $to);
        wp_safe_redirect($to);
        exit;
    }

    private static function reset_rank_tracker() {
        global $wpdb;
        // Drop plugin-owned tables only. Table names are fixed (whitelist), not user input.
        // phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.SchemaChange
        $wpdb->query("DROP TABLE IF EXISTS `{$wpdb->prefix}miro_rt_keywords`, `{$wpdb->prefix}miro_rt_snapshots`, `{$wpdb->prefix}miro_rt_competitors`");
        // Options/status/keys
        delete_option('miro_rt_settings');
        delete_option('miro_rt_status');
        delete_option('miro_broker_base');
        delete_option('miro_hmac_secret');
        // Cron/transient
        wp_clear_scheduled_hook('miro_rt_hourly');
        delete_transient('miro_rt_cron_lock');
    }

    private static function reset_index_monitor() {
        // Settings
        delete_option('miro_index_settings');
        // Post meta
        delete_post_meta_by_key('_miro_index_status');
        delete_post_meta_by_key('_miro_index_details');
        delete_post_meta_by_key('_miro_index_last_check');
        delete_post_meta_by_key('_miro_index_first_seen_notidx');
        delete_post_meta_by_key('_miro_index_retry_count');
        // Cron
        wp_clear_scheduled_hook('miro_index_monitor_daily');
    }
}
