<?php
/**
 * Pro upsell: when MIRO_AI_SEO_IS_FREE, registers Pro menu items and renders
 * a single upsell page (feature description + Upgrade to Pro button).
 */
namespace Miro_AI_SEO;

if (!defined('ABSPATH')) { exit; }

class Miro_Pro_Upsell {

    const UPGRADE_URL = 'https://miroseo.com';

    public static function get_pro_features(): array {
        return [
            'miro-ai-trends' => [
                'title'       => __('Trend Finder', 'miro-ai-seo'),
                'menu_title'  => __('Trend Finder', 'miro-ai-seo') . ' PRO',
                'description' => __('Discover trending topics and search demand to create content that ranks.', 'miro-ai-seo'),
                'features'    => [
                    __('See what\'s rising in your niche', 'miro-ai-seo'),
                    __('Align content strategy with real search behavior', 'miro-ai-seo'),
                    __('Trend data and demand signals', 'miro-ai-seo'),
                ],
            ],
            'miro-ai-keyword-lab' => [
                'title'       => __('AI Keyword Lab', 'miro-ai-seo'),
                'menu_title'  => __('AI Keyword Lab', 'miro-ai-seo') . ' PRO',
                'description' => __('Research and cluster keywords with AI.', 'miro-ai-seo'),
                'features'    => [
                    __('Keyword suggestions and search volume estimates', 'miro-ai-seo'),
                    __('Content ideas for the right queries', 'miro-ai-seo'),
                    __('Cluster and organize keywords', 'miro-ai-seo'),
                ],
            ],
            'miro-ai-suite' => [
                'title'       => __('AI Content Suite', 'miro-ai-seo'),
                'menu_title'  => __('AI Content Suite', 'miro-ai-seo') . ' PRO',
                'description' => __('Optimize titles, meta, and content with AI in one place.', 'miro-ai-seo'),
                'features'    => [
                    __('Optimize titles and meta descriptions', 'miro-ai-seo'),
                    __('Rewrite content with AI', 'miro-ai-seo'),
                    __('Generate FAQ blocks', 'miro-ai-seo'),
                    __('On-page SEO improvements', 'miro-ai-seo'),
                ],
            ],
            'miro-ai-post-generator' => [
                'title'       => __('AI Post Generator', 'miro-ai-seo'),
                'menu_title'  => __('AI Post Generator', 'miro-ai-seo') . ' PRO',
                'description' => __('Generate full SEO-optimized posts from a keyword or topic.', 'miro-ai-seo'),
                'features'    => [
                    __('Create posts built for search from the start', 'miro-ai-seo'),
                    __('Save time with AI-generated drafts', 'miro-ai-seo'),
                    __('SEO-optimized structure and meta', 'miro-ai-seo'),
                ],
            ],
            'miro-ai-fix-bulk' => [
                'title'       => __('AI Fix (Bulk)', 'miro-ai-seo'),
                'menu_title'  => __('AI Fix (Bulk)', 'miro-ai-seo') . ' PRO',
                'description' => __('Bulk-optimize titles and meta across many posts with AI.', 'miro-ai-seo'),
                'features'    => [
                    __('Fix thin or duplicate meta at scale', 'miro-ai-seo'),
                    __('Bulk title and description optimization', 'miro-ai-seo'),
                    __('AI-powered suggestions for many posts', 'miro-ai-seo'),
                ],
            ],
            'miro-ai-internal-links' => [
                'title'       => __('Internal Links', 'miro-ai-seo'),
                'menu_title'  => __('Internal Links', 'miro-ai-seo') . ' PRO',
                'description' => __('Smart internal linking suggestions and management.', 'miro-ai-seo'),
                'features'    => [
                    __('Get link suggestions from one place', 'miro-ai-seo'),
                    __('Strengthen site structure', 'miro-ai-seo'),
                    __('Pass authority to key pages', 'miro-ai-seo'),
                ],
            ],
            'miro-fix-center' => [
                'title'       => __('Fix Center', 'miro-ai-seo'),
                'menu_title'  => __('Fix Center', 'miro-ai-seo') . ' PRO',
                'description' => __('Improve click-through from search with CTR-focused suggestions.', 'miro-ai-seo'),
                'features'    => [
                    __('See which titles and snippets can be tuned', 'miro-ai-seo'),
                    __('CTR optimization suggestions', 'miro-ai-seo'),
                    __('Apply fixes in bulk', 'miro-ai-seo'),
                ],
            ],
            'miro-instant-index' => [
                'title'       => __('Instant Indexing', 'miro-ai-seo'),
                'menu_title'  => __('Instant Indexing', 'miro-ai-seo') . ' PRO',
                'description' => __('Submit URLs to IndexNow (Bing, Yandex) for faster discovery.', 'miro-ai-seo'),
                'features'    => [
                    __('Automatic submissions on publish', 'miro-ai-seo'),
                    __('Speed up discovery of new or updated content', 'miro-ai-seo'),
                    __('Configurable limits and triggers', 'miro-ai-seo'),
                ],
            ],
            'miro-reports' => [
                'title'       => __('Reports', 'miro-ai-seo'),
                'menu_title'  => __('Reports', 'miro-ai-seo') . ' PRO',
                'description' => __('Scheduled reports and alerts for SEO performance.', 'miro-ai-seo'),
                'features'    => [
                    __('Scheduled PDF/email reports', 'miro-ai-seo'),
                    __('White-label options for agencies', 'miro-ai-seo'),
                    __('Keyword drop alerts', 'miro-ai-seo'),
                    __('Share performance with clients or team', 'miro-ai-seo'),
                ],
            ],
        ];
    }

    public static function init(): void {
        if (!defined('MIRO_AI_SEO_IS_FREE') || !MIRO_AI_SEO_IS_FREE) {
            return;
        }
        add_action('admin_menu', [__CLASS__, 'register_menus'], 999);
    }

    public static function register_menus(): void {
        $parent = apply_filters('miro_main_menu_slug', 'miro-ai-seo');
        $cap    = function_exists('miro_ai_cap') ? miro_ai_cap() : 'edit_posts';
        $features = self::get_pro_features();
        $position = 13;
        foreach ($features as $slug => $info) {
            $menu_title = isset($info['menu_title']) ? $info['menu_title'] : ($info['title'] . ' PRO');
            $page_title = $info['title'];
            if (!function_exists('miro_ai_add_submenu_once')) {
                add_submenu_page($parent, $page_title, $menu_title, $cap, $slug, [__CLASS__, 'render_upsell'], $position);
            } else {
                miro_ai_add_submenu_once($parent, $page_title, $menu_title, $cap, $slug, [__CLASS__, 'render_upsell'], $position);
            }
            $position++;
        }
    }

    public static function render_upsell(): void {
        $slug = isset($_GET['page']) ? sanitize_key((string) wp_unslash($_GET['page'])) : '';
        $features = self::get_pro_features();
        $info = isset($features[$slug]) ? $features[$slug] : ['title' => __('Premium Feature', 'miro-ai-seo'), 'description' => __('This feature is available in the premium upgrade.', 'miro-ai-seo'), 'features' => []];
        $url = defined('MIRO_AI_SEO_UPGRADE_URL') ? MIRO_AI_SEO_UPGRADE_URL : self::UPGRADE_URL;
        $logo = defined('MIRO_AI_SEO_URL') ? MIRO_AI_SEO_URL . 'assets/img/miro-logo.webp' : '';
        $features_list = isset($info['features']) && is_array($info['features']) ? $info['features'] : [];
        ?>
        <div class="wrap miro-alt-wrap">
            <div class="af-hero">
                <div class="af-hero-pill">
                    <div class="af-hero-pill-inner">
                        <?php if ($logo) : ?>
                            <img src="<?php echo esc_url($logo); ?>" alt="<?php esc_attr_e('Miro AI SEO', 'miro-ai-seo'); ?>">
                        <?php else : ?>
                            <div class="af-hero-pill-fallback">MIRO</div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="miro-pro-upsell-card" style="max-width:560px; margin:24px 0; padding:28px; background:#fff; border:1px solid #e5e7eb; border-radius:16px; box-shadow:0 4px 24px rgba(0,0,0,0.06);">
                <h1 class="miro-pro-upsell-title" style="margin-top:0; font-size:1.5rem;"><?php echo esc_html($info['title']); ?></h1>
                <p class="miro-pro-upsell-desc" style="color:#4b5563; line-height:1.6;"><?php echo esc_html($info['description']); ?></p>
                <?php if (!empty($features_list)) : ?>
                    <p style="margin:16px 0 8px; font-weight:600; color:#374151;"><?php esc_html_e('Features:', 'miro-ai-seo'); ?></p>
                    <ul style="color:#4b5563; line-height:1.7; margin:0 0 20px 20px; padding:0;">
                        <?php foreach ($features_list as $f) : ?>
                            <li><?php echo esc_html($f); ?></li>
                        <?php endforeach; ?>
                    </ul>
                <?php endif; ?>
                <p style="margin-top:24px;">
                    <a href="<?php echo esc_url($url); ?>" target="_blank" rel="noopener noreferrer" class="button button-primary button-hero">
                        <?php esc_html_e('Upgrade', 'miro-ai-seo'); ?> →
                    </a>
                </p>
            </div>
        </div>
        <?php
    }

    public static function get_upgrade_url(): string {
        return defined('MIRO_AI_SEO_UPGRADE_URL') ? MIRO_AI_SEO_UPGRADE_URL : self::UPGRADE_URL;
    }
}
