<?php
/**
 * GSC Analytics: Pro tab stubs for free version.
 * When MIRO_AI_SEO_IS_FREE, registers same tab names but shows upsell content only.
 */
namespace Miro_AI_SEO;

if (!defined('ABSPATH')) { exit; }

class Miro_GSC_Pro_Tabs {

    /** tab_id => [ label, description, features[] ] */
    private static function get_pro_tabs(): array {
        return [
            'tab-presence'      => [
                'label' => __('Presence on Google', 'miro-ai-seo') . ' PRO',
                'desc'  => __('See how your site appears across Google search.', 'miro-ai-seo'),
                'features' => [__('Presence overview', 'miro-ai-seo'), __('Coverage and indexing insights', 'miro-ai-seo')],
            ],
            'tab-pages'        => [
                'label' => __('Pages', 'miro-ai-seo') . ' PRO',
                'desc'  => __('Performance by page with detailed metrics.', 'miro-ai-seo'),
                'features' => [__('Page-level clicks and impressions', 'miro-ai-seo'), __('Sort and filter by performance', 'miro-ai-seo')],
            ],
            'tab-rankflow'     => [
                'label' => __('RankFlow', 'miro-ai-seo') . ' PRO',
                'desc'  => __('Track ranking changes and momentum over time.', 'miro-ai-seo'),
                'features' => [__('Rank flow visualization', 'miro-ai-seo'), __('Keyword movement tracking', 'miro-ai-seo')],
            ],
            'tab-easy_keywords'=> [
                'label' => __('Easy Keywords', 'miro-ai-seo') . ' PRO',
                'desc'  => __('Quick-win keywords with scores and actions.', 'miro-ai-seo'),
                'features' => [__('Scored keyword list', 'miro-ai-seo'), __('Easy-to-act-on suggestions', 'miro-ai-seo')],
            ],
            'tab-rank_today'   => [
                'label' => __('Rank Today', 'miro-ai-seo') . ' PRO',
                'desc'  => __('Current ranking snapshot for your keywords.', 'miro-ai-seo'),
                'features' => [__('Today\'s rank snapshot', 'miro-ai-seo'), __('Position tracking', 'miro-ai-seo')],
            ],
            'tab-rank'         => [
                'label' => __('Rank Tracker', 'miro-ai-seo') . ' PRO',
                'desc'  => __('Track keyword rankings over time.', 'miro-ai-seo'),
                'features' => [__('Historical rank data', 'miro-ai-seo'), __('Trends and changes', 'miro-ai-seo')],
            ],
            'tab-ai'           => [
                'label' => __('AI Suggestions', 'miro-ai-seo') . ' PRO',
                'desc'  => __('AI-powered recommendations for your GSC data.', 'miro-ai-seo'),
                'features' => [__('AI insights and recommendations', 'miro-ai-seo'), __('Actionable suggestions', 'miro-ai-seo')],
            ],
            'tab-gap'          => [
                'label' => __('Content Gap', 'miro-ai-seo') . ' PRO',
                'desc'  => __('Find content opportunities from search data.', 'miro-ai-seo'),
                'features' => [__('Content gap analysis', 'miro-ai-seo'), __('Opportunity keywords', 'miro-ai-seo')],
            ],
            'tab-quickwins'    => [
                'label' => __('Quick-Wins', 'miro-ai-seo') . ' PRO',
                'desc'  => __('Fast improvements you can apply now.', 'miro-ai-seo'),
                'features' => [__('Quick-win actions', 'miro-ai-seo'), __('One-click apply where possible', 'miro-ai-seo')],
            ],
        ];
    }

    public static function init(): void {
        if (!defined('MIRO_AI_SEO_IS_FREE') || !MIRO_AI_SEO_IS_FREE) {
            return;
        }
        add_action('miro_gsc_tabs_nav_after', [__CLASS__, 'nav'], 5);
        add_action('miro_gsc_tabs_content', [__CLASS__, 'content'], 99);
    }

    public static function nav(): void {
        $tabs = self::get_pro_tabs();
        foreach ($tabs as $id => $data) {
            echo '<a href="#' . esc_attr($id) . '" class="tab-link">' . esc_html($data['label']) . '</a>';
        }
    }

    public static function content(): void {
        $url = defined('MIRO_AI_SEO_UPGRADE_URL') ? MIRO_AI_SEO_UPGRADE_URL : \Miro_AI_SEO\Miro_Pro_Upsell::UPGRADE_URL;
        $tabs = self::get_pro_tabs();
        foreach ($tabs as $id => $data) {
            echo '<section id="' . esc_attr($id) . '" class="tab-pan" style="display:none;">';
            echo '<div class="miro-pro-upsell-inline" style="padding:32px 24px; background:#f8fafc; border-radius:12px; border:1px solid #e2e8f0; margin:16px 0;">';
            echo '<h3 style="margin-top:0;">' . esc_html($data['label']) . '</h3>';
            echo '<p style="color:#475569; line-height:1.6;">' . esc_html($data['desc']) . '</p>';
            if (!empty($data['features'])) {
                echo '<p style="margin:12px 0 8px; font-weight:600; color:#374151;">' . esc_html__('Features:', 'miro-ai-seo') . '</p>';
                echo '<ul style="color:#475569; line-height:1.7; margin:0 0 20px 20px; padding:0;">';
                foreach ($data['features'] as $f) {
                    echo '<li>' . esc_html($f) . '</li>';
                }
                echo '</ul>';
            }
            echo '<p><a href="' . esc_url($url) . '" target="_blank" rel="noopener noreferrer" class="button button-primary">' . esc_html__('Upgrade', 'miro-ai-seo') . ' →</a></p>';
            echo '</div></section>';
        }
    }
}
