<?php
namespace Miro_AI_SEO;

if (!defined('ABSPATH')) exit;

// Nav
add_action('miro_gsc_tabs_nav', function () {
    echo '<a href="#tab-ideas" class="tab-link">Keyword Ideas (Content-Based)</a>';
});

// Content
add_action('miro_gsc_tabs_content', function () {
    $nonce = wp_create_nonce('wp_rest');
    $rest_base = rest_url('miro/v1/');
    $rest_config = [
        'list'  => $rest_base . 'analytics/ideas',
        'ai'    => $rest_base . 'analytics/ideas/ai',
        'nonce' => $nonce,
    ];
    ?>
    <section id="tab-ideas" class="tab-pan" style="display:none;">
      <div class="controls" style="margin:12px 0;">
        <label>Types: <input id="ki-types" class="input" value="post,page" style="width:160px"></label>
        <label>Scan posts: <input id="ki-limit" type="number" class="input" value="300" min="50" max="5000" style="width:100px"></label>
        <label>Words: <input id="ki-min" type="number" class="input" value="2" min="1" max="8" style="width:72px"> – <input id="ki-max" type="number" class="input" value="5" min="2" max="8" style="width:72px"></label>
        <label>Min freq: <input id="ki-freq" type="number" class="input" value="2" min="1" max="50" style="width:80px"></label>
        <label><input type="checkbox" id="ki-ex-brand" checked> Exclude brand tokens</label>
        <button id="ki-apply" class="btn primary">Generate Ideas</button>
      </div>

      <div class="card">
        <table id="ki-table">
          <thead>
            <tr>
              <th>Keyword Idea</th>
              <th style="text-align:right;">Words</th>
              <th style="text-align:right;">Freq</th>
              <th style="text-align:right;">Gap?</th>
              <th style="text-align:right;">Score</th>
              <th style="text-align:right;">AI</th>
            </tr>
          </thead>
          <tbody></tbody>
        </table>
        <div style="display:flex;gap:8px;justify-content:flex-end;margin-top:10px;">
          <button id="ki-prev" class="btn">Prev</button>
          <span id="ki-page" class="badge">1</span>
          <button id="ki-next" class="btn">Next</button>
        </div>
      </div>
    </section>
    <script>
    (function(){
      const REST = <?php echo wp_json_encode($rest_config); ?>;
      function GET(u){ return fetch(u,{headers:{ "X-WP-Nonce":REST.nonce }}).then(r=>r.json()); }
      function POST(u,b){ return fetch(u,{method:"POST",headers:{ "Content-Type":"application/json","X-WP-Nonce":REST.nonce },body:JSON.stringify(b||{})}).then(r=>r.json()); }

      const q = {
        types: document.getElementById("ki-types"),
        limit: document.getElementById("ki-limit"),
        min:   document.getElementById("ki-min"),
        max:   document.getElementById("ki-max"),
        freq:  document.getElementById("ki-freq"),
        exb:   document.getElementById("ki-ex-brand"),
        apply: document.getElementById("ki-apply"),
        table: document.getElementById("ki-table").querySelector("tbody"),
        prev:  document.getElementById("ki-prev"),
        next:  document.getElementById("ki-next"),
        pageEl:document.getElementById("ki-page")
      };

      let page=1, per_page=50, total=0;

      async function load(){
        const params = new URLSearchParams({
          types: (q.types.value||"post,page"),
          limit: q.limit.value || 300,
          min_len: q.min.value || 2,
          max_len: q.max.value || 5,
          min_freq: q.freq.value || 2,
          exclude_brand: q.exb.checked ? 1 : 0,
          page, per_page
        });
        const data = await GET(REST.list + "?" + params.toString());
        total = data.total || 0;
        q.pageEl.textContent = String(page);

        const rows = data.rows || [];
        q.table.innerHTML = rows.map(r => {
          const esc = (s)=>String(s).replace(/[&<>"]/g, m=>({ "&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;" }[m]));
          return `<tr>
            <td>${esc(r.idea)}</td>
            <td style="text-align:right;">${(r.words||0)}</td>
            <td style="text-align:right;">${(r.freq||0)}</td>
            <td style="text-align:right;">${r.known ? "No (already in GSC)" : "Yes"}</td>
            <td style="text-align:right;"><strong>${(r.score||0).toFixed(4)}</strong></td>
            <td style="text-align:right;">
              <button class="btn btn-mini" data-ai="expand" data-idea="${esc(r.idea)}">Expand</button>
              <button class="btn btn-mini" data-ai="title"  data-idea="${esc(r.idea)}">Title</button>
              <button class="btn btn-mini" data-ai="meta"   data-idea="${esc(r.idea)}">Meta</button>
              <button class="btn btn-mini" data-ai="brief"  data-idea="${esc(r.idea)}">Brief</button>
            </td>
          </tr>`;
        }).join("");
      }

      q.apply.addEventListener("click", ()=>{ page=1; load(); });
      q.prev.addEventListener("click", ()=>{ if(page>1){ page--; load(); }});
      q.next.addEventListener("click", ()=>{ if(page*per_page < total){ page++; load(); }});

      document.getElementById("ki-table").addEventListener("click", async (e)=>{
        const b = e.target.closest("button[data-ai]");
        if(!b) return;
        b.disabled=true; const prev=b.textContent; b.textContent="…";
        try{
          const r = await POST(REST.ai, { type: b.getAttribute("data-ai"), idea: b.getAttribute("data-idea") });
          alert(r && r.text ? r.text : "No AI text");
        } catch(err){ alert("AI error"); }
        b.textContent=prev; b.disabled=false;
      });

      // Load on tab show
      const thisTab = document.getElementById("tab-ideas");
      const obs = new MutationObserver(()=>{ if (thisTab.style.display !== "none" && !total) load(); });
      obs.observe(thisTab, { attributes:true, attributeFilter:["style"] });
    })();
    </script>
    <?php
});
