(function(){
  var cfg = window.MiroIndexAdminCFG || {};
  function get(url){
    return fetch(url, { headers: { 'X-WP-Nonce': cfg.nonce } })
      .then(function(r){ return r.json(); });
  }
  function post(url, data){
    return fetch(url, {
      method: 'POST',
      headers: { 'Content-Type':'application/json', 'X-WP-Nonce': cfg.nonce },
      body: JSON.stringify(data || {})
    }).then(function(r){ return r.json(); });
  }

  document.addEventListener('click', function(e){
    if (e.target && e.target.id === 'miro-index-rescan') {
      var msg = document.getElementById('miro-index-rescan-msg');
      if (msg) msg.textContent = 'Queuing and running first batch…';
      post(cfg.restRescan, {}).then(function(res){
        if (msg) msg.textContent = 'Done: Backfill queued. First batch processed.';
      }).catch(function(err){
        if (msg) msg.textContent = 'Error: ' + (err && err.message ? err.message : 'request failed');
      });
    }
    if (e.target && e.target.id === 'miro-gsc-refresh') {
      var select = document.getElementById('miro-gsc-prop');
      var hidden = document.getElementById('miro-gsc-prop-hidden');
      if (!select) return;
      select.innerHTML = '<option>Loading…</option>';
      get(cfg.restSites).then(function(res){
        var arr = (res && res.sites) ? res.sites : [];
        select.innerHTML = '';
        if (!arr.length) {
          var o = document.createElement('option');
          o.value = ''; o.textContent = '— None found —';
          select.appendChild(o);
        } else {
          arr.forEach(function(s){
            var o = document.createElement('option');
            o.value = s.siteUrl || '';
            o.textContent = (s.siteUrl || '') + (s.verified===false ? ' (unverified)' : '');
            select.appendChild(o);
          });
        }
        if (hidden && hidden.value) {
          // try to select the override if present
          for (var i=0;i<select.options.length;i++){
            if (select.options[i].value === hidden.value) {
              select.selectedIndex = i; break;
            }
          }
        }
      }).catch(function(){
        select.innerHTML = '<option>Error loading sites</option>';
      });
    }
  });

  document.addEventListener('change', function(e){
    if (e.target && e.target.id === 'miro-gsc-prop') {
      var hidden = document.getElementById('miro-gsc-prop-hidden');
      if (hidden) hidden.value = e.target.value || '';
    }
  });
})();
