(function($){
  function post(url, data){
    return fetch(url, {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
        'X-WP-Nonce': MiroIndex.nonce
      },
      body: JSON.stringify(data || {})
    }).then(async r => {
      const txt = await r.text();
      let json;
      try { json = JSON.parse(txt); } catch(e){ json = { message: txt || ('HTTP ' + r.status) }; }
      if (!r.ok) {
        const msg = (json && (json.message || json.code)) ? (json.message || json.code) : ('HTTP ' + r.status);
        throw new Error(msg);
      }
      return json;
    });
  }

  $(document).on('click', '.miro-index-check', function(){
    var pid = $(this).data('post');
    var $msg = $('#miro-index-msg');
    $msg.text('Checking…');
    post(MiroIndex.rest_check, { post_id: pid })
      .then(function(res){
        var status = (res && res.status) ? res.status : 'unknown';
        var when   = (res && res.last_check) ? res.last_check : '';
        $msg.text('Status: ' + status + (when ? (' • Last check: ' + when) : ''));
        // Optionally refresh the page to update the badge:
        // location.reload();
      })
      .catch(function(err){
        $msg.text('Error checking. ' + err.message);
      });
  });

  $(document).on('click', '.miro-index-ping', function(){
    var pid = $(this).data('post');
    var $msg = $('#miro-index-msg');
    $msg.text('Re-indexing (best effort)…');
    post(MiroIndex.rest_ping, { post_id: pid })
      .then(function(res){
        var acts = (res && res.actions) ? res.actions.join(', ') : '';
        $msg.text('Triggered: ' + acts + '. You can Check Now again in a few minutes.');
      })
      .catch(function(err){
        $msg.text('Error. ' + err.message);
      });
  });
})(jQuery);
