<?php
namespace Miro_AI_SEO;

if (!defined('ABSPATH')) exit;

class Miro_REST_AI {

    public static function init() {
        add_action('rest_api_init', [__CLASS__, 'register_routes']);
    }

    public static function register_routes() {

        register_rest_route('miro/v1', '/ai/complete', [
            'methods'  => 'POST',
            'callback' => [__CLASS__, 'endpoint_complete'],
            'permission_callback' => function () {
                return current_user_can('edit_posts');
            },
            'args' => [
                'prompt' => [
                    'type' => 'string',
                    'required' => true,
                    'sanitize_callback' => 'sanitize_textarea_field',
                    'validate_callback' => function($param) {
                        $len = function_exists('mb_strlen') ? mb_strlen($param) : strlen($param);
                        return $len > 0 && $len <= 10000;
                    }
                ],
                'context' => [
                    'type' => 'string',
                    'required' => false,
                    'sanitize_callback' => 'sanitize_key',
                    'validate_callback' => function($param) {
                        return strlen($param) <= 100;
                    }
                ]
            ]
        ]);

    }

    /**
     * POST /miro/v1/ai/complete
     * Body:
     * {
     *   "prompt": "text",
     *   "context": "ai-suite"
     * }
     */
    public static function endpoint_complete(\WP_REST_Request $req) {

        $prompt  = trim((string)$req->get_param('prompt'));
        $context = trim((string)$req->get_param('context'));

        if (empty($prompt)) {
            return new \WP_Error('bad_request', 'Empty prompt', ['status' => 400]);
        }

        // Use the main plugin AI bridge
        $result = apply_filters('miro/ai/complete', '', [
            'prompt'  => $prompt,
            'context' => $context,
            'opts'    => [
                'model' => 'gpt-4o-mini',
                'temperature' => 0.2,
                'max_tokens'  => 800,
            ]
        ]);

        if (!$result) {
            return ['error' => 'AI returned empty response. Check API key.'];
        }

        return [
            'text' => $result
        ];
    }

}
Miro_REST_AI::init();
