<?php
/**
 * Loaded by miro-ai-seo.php (main plugin file). Plugin name and text domain
 * are set there: Miro AI SEO, miro-ai-seo. This file is not the plugin header.
 */

if (!defined('ABSPATH')) { exit; }

/* -----------------------------------------------------------------------------
 * Constants (free version sets these in miro-ai-seo.php before requiring this file)
 * --------------------------------------------------------------------------- */
if (!defined('MIRO_AI_SEO_VERSION')) define('MIRO_AI_SEO_VERSION', '1.0.0');
if (!defined('MIRO_AI_SEO_FILE'))    define('MIRO_AI_SEO_FILE', __FILE__);
if (!defined('MIRO_AI_SEO_DIR'))     define('MIRO_AI_SEO_DIR', plugin_dir_path(__FILE__));
if (!defined('MIRO_AI_SEO_URL'))     define('MIRO_AI_SEO_URL', plugin_dir_url(__FILE__));
if (!defined('MIRO_AI_MAIN_FILE'))   define('MIRO_AI_MAIN_FILE', __FILE__);
if (!defined('MIRO_AI_SEO_IS_FREE')) define('MIRO_AI_SEO_IS_FREE', false);
if (!defined('MIRO_AI_SEO_UPGRADE_URL')) define('MIRO_AI_SEO_UPGRADE_URL', 'https://miroseo.com');

if (defined('MIRO_AI_SEO_IS_FREE') && MIRO_AI_SEO_IS_FREE && !function_exists('miro_ai_seo_free_domain')) {
    function miro_ai_seo_free_domain() { return 'miro-ai-seo'; }
}

/* -----------------------------------------------------------------------------
 * Safe loader helpers (prevents fatal errors → CodeCanyon-safe)
 * --------------------------------------------------------------------------- */
if (!function_exists('miro_notice_missing_file')) {
    function miro_notice_missing_file(string $abs_path): void {
        if (!is_admin()) return;
        add_action('admin_notices', function() use ($abs_path) {
            if (!current_user_can('manage_options')) return;
            echo '<div class="notice notice-error"><p><strong>Miro AI SEO:</strong> Missing file: <code>'
               . esc_html(str_replace(ABSPATH, '', $abs_path))
               . '</code></p></div>';
        });
    }
}

if (!function_exists('miro_safe_require')) {
    function miro_safe_require(string $abs_path): bool {
        if (file_exists($abs_path)) {
            require_once $abs_path;
            return true;
        }
        miro_notice_missing_file($abs_path);
        return false;
    }
}

if (!function_exists('miro_safe_init_class')) {
    /**
     * Init static method safely.
     * @param string $class1 Full class name (with namespace)
     * @param string|null $class2 Optional fallback class name
     */
    function miro_safe_init_class(string $class1, ?string $class2 = null, string $method = 'init'): void {
        if (class_exists($class1) && is_callable([$class1, $method])) {
            $class1::$method();
            return;
        }
        if ($class2 && class_exists($class2) && is_callable([$class2, $method])) {
            $class2::$method();
            return;
        }
    }
}

/* -----------------------------------------------------------------------------
 * Capability helper (default Editors+ for UI; Admins only for dangerous actions)
 * --------------------------------------------------------------------------- */
if (!function_exists('miro_ai_cap')) {
    function miro_ai_cap() {
        return apply_filters('miro/capability', 'edit_posts');
    }
}

if (!function_exists('miro_ai_manage_cap')) {
    function miro_ai_manage_cap() {
        return apply_filters('miro/manage_capability', 'manage_options');
    }
}

/* ----------------------------------------------------------------------------- 
 * Conflict Detection (safe)
 * --------------------------------------------------------------------------- */

/* ----------------------------------------------------------------------------- 
 * Fix Center: enqueue + localize (Pro only; free shows upsell)
 * --------------------------------------------------------------------------- */
if (!defined('MIRO_AI_SEO_IS_FREE') || !MIRO_AI_SEO_IS_FREE) {
add_action('admin_enqueue_scripts', function($hook){
    // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Read-only page detection for conditional asset loading.
    $page = isset($_GET['page']) ? sanitize_key((string)wp_unslash($_GET['page'])) : '';
    if ($page !== 'miro-fix-center') return;

    wp_enqueue_script(
        'miro-fix-center',
        MIRO_AI_SEO_URL . 'assets/js/miro-fix-center.js',
        ['jquery'],
        (file_exists(MIRO_AI_SEO_DIR . 'assets/js/miro-fix-center.js') ? filemtime(MIRO_AI_SEO_DIR . 'assets/js/miro-fix-center.js') : MIRO_AI_SEO_VERSION),
        true
    );

    // Use index.php?rest_route (because /wp-json might be blocked/redirected)
    $u = function($route){
        return home_url('/index.php?rest_route=' . $route);
    };

    wp_localize_script('miro-fix-center', 'miroFixCenter', [
        'nonce' => wp_create_nonce('wp_rest'),
        'rest'  => [
            'scan'  => $u('/miro/v1/fix/ctr/scan'),
            'apply' => $u('/miro/v1/fix/ctr/apply'),
            'undo'  => $u('/miro/v1/fix/ctr/undo'),
            'hist'  => $u('/miro/v1/fix/ctr/history'),
            'check' => $u('/miro/v1/fix/ctr/check'),
        ],
    ]);

}, 999);
}

/* -----------------------------------------------------------------------------
 * Free version: Pro upsell (menu items + upgrade page)
 * --------------------------------------------------------------------------- */
if (defined('MIRO_AI_SEO_IS_FREE') && MIRO_AI_SEO_IS_FREE) {
    $miro_upsell = MIRO_AI_SEO_DIR . 'includes/class-miro-pro-upsell.php';
    if (file_exists($miro_upsell)) {
        require_once $miro_upsell;
        \Miro_AI_SEO\Miro_Pro_Upsell::init();
    }
}

add_action('admin_enqueue_scripts', function($hook){
    // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Read-only page detection for conditional asset loading.
    $page = isset($_GET['page']) ? sanitize_key((string)wp_unslash($_GET['page'])) : '';
    if ($page !== 'miro-gsc-analytics') return;
    wp_enqueue_style('miro-rankflow', MIRO_AI_SEO_URL . 'assets/css/rankflow.css', [], MIRO_AI_SEO_VERSION);
});

/* ----------------------------------------------------------------------------- 
 * Manual RankFlow snapshot rebuild (already nonce+cap guarded ✅)
 * --------------------------------------------------------------------------- */
add_action('init', function () {
    // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Nonce checked below
    if (!empty($_GET['miro_rankflow_build'])) {
        if (!current_user_can('manage_options')) {
            wp_die(esc_html__('Unauthorized', 'miro-ai-seo'), '', ['response' => 403]);
        }
        // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.MissingUnslash, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized -- Nonce verified by wp_verify_nonce
        if (!isset($_GET['_wpnonce']) || !wp_verify_nonce(sanitize_text_field(wp_unslash($_GET['_wpnonce'])), 'miro_rankflow_build')) {
            wp_die(esc_html__('Invalid nonce', 'miro-ai-seo'), '', ['response' => 403]);
        }
        if (class_exists('\Miro_AI_SEO\RankFlow_Snapshot')) {
            \Miro_AI_SEO\RankFlow_Snapshot::build_snapshot();
            wp_die('<h1>' . esc_html__('RankFlow snapshot rebuilt successfully.', 'miro-ai-seo') . '</h1>');
        }
        wp_die('<h1>' . esc_html__('Snapshot builder missing.', 'miro-ai-seo') . '</h1>');
    }
});

/* ----------------------------------------------------------------------------- 
 * Index metabox script (editor only)
 * --------------------------------------------------------------------------- */
add_action('admin_enqueue_scripts', function($hook){

    if ($hook !== 'post.php' && $hook !== 'post-new.php') return;

    wp_enqueue_script(
        'miro-index-metabox',
        MIRO_AI_SEO_URL . 'assets/js/index-metabox.js',
        ['jquery'],
        MIRO_AI_SEO_VERSION,
        true
    );

    wp_localize_script('miro-index-metabox', 'miroIndex', [
        'rest'  => esc_url_raw( rest_url('miro/v1/') ),
        'nonce' => wp_create_nonce('wp_rest')
    ]);
});

/* ----------------------------------------------------------------------------- 
 * REST includes (safe require + safe init)
 * --------------------------------------------------------------------------- */
// AI Suggest Endpoint
miro_safe_require(MIRO_AI_SEO_DIR . 'includes/rest/class-miro-rest-title-ai.php');
miro_safe_init_class('\Miro_AI_SEO\Miro_REST_Title_AI', null);

// Score REST engine removed for CodeCanyon release

// Central AI REST
miro_safe_require(MIRO_AI_SEO_DIR . 'includes/rest/class-miro-rest-ai.php');

/* ----------------------------------------------------------------------------- 
 * Fix Center (Pro only; free = upsell)
 * --------------------------------------------------------------------------- */
if (!defined('MIRO_AI_SEO_IS_FREE') || !MIRO_AI_SEO_IS_FREE) {
add_action('plugins_loaded', function () {

    $admin_file = MIRO_AI_SEO_DIR . 'includes/modules/fix-center/class-miro-fix-center.php';
    $rest_file  = MIRO_AI_SEO_DIR . 'includes/rest/class-miro-rest-fix-center.php';

    miro_safe_require($admin_file);
    miro_safe_require($rest_file);

    miro_safe_init_class('\Miro_AI_SEO\Miro_Fix_Center', null);
    miro_safe_init_class('\Miro_AI_SEO\Miro_REST_Fix_Center', null);

}, 1);
}

/* ----------------------------------------------------------------------------- 
 * Global admin CSS (ONLY on our pages) + SS STYLE CSS (ONLY on SS pages)
 * --------------------------------------------------------------------------- */
add_action('admin_enqueue_scripts', function () {
    // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Read-only page detection for conditional asset loading.
    $page = isset($_GET['page']) ? sanitize_key((string)wp_unslash($_GET['page'])) : '';

    // Only load on Miro pages (keeps WP fast)
    if (!$page || ($page !== 'miro-ai-seo' && strpos($page, 'miro-') !== 0)) return;

    // 1) Global admin CSS (shared)
    $rel  = 'assets/css/miro-admin.css';
    $file = MIRO_AI_SEO_DIR . $rel;
    $url  = MIRO_AI_SEO_URL . $rel;
    $ver  = file_exists($file) ? filemtime($file) : MIRO_AI_SEO_VERSION;

    wp_enqueue_style('ppmiro-admin', $url, [], $ver);

    // 2) SS STYLE pages only (load EXTRA css only where needed)
    $ss_pages = [
        'miro-ai-trends',
        'miro-ai-seo', // Dashboard
        // 'miro-alt-fix',
        // 'miro-404-monitor'
    ];

    if (in_array($page, $ss_pages, true)) {
        $rel2  = 'assets/css/miro-alt.css';
        $file2 = MIRO_AI_SEO_DIR . $rel2;
        $url2  = MIRO_AI_SEO_URL . $rel2;
        $ver2  = file_exists($file2) ? filemtime($file2) : MIRO_AI_SEO_VERSION;

        wp_enqueue_style('miro-alt', $url2, ['ppmiro-admin'], $ver2);
    }
    
    // 3) Fix Center style hero pages (Settings, GSC Connect, Index Monitor)
    $af_hero_pages = [
        'miro-ai-settings',
        'miro-gsc', // Google Search Console
        'miro-index', // Index Monitor
    ];
    
    if (in_array($page, $af_hero_pages, true)) {
        $rel2  = 'assets/css/miro-alt.css';
        $file2 = MIRO_AI_SEO_DIR . $rel2;
        $url2  = MIRO_AI_SEO_URL . $rel2;
        $ver2  = file_exists($file2) ? filemtime($file2) : MIRO_AI_SEO_VERSION;

        wp_enqueue_style('miro-alt', $url2, ['ppmiro-admin'], $ver2);
    }

}, 20);

/* ----------------------------------------------------------------------------- 
 * AI FAQ (safe load + init)
 * --------------------------------------------------------------------------- */
miro_safe_require(MIRO_AI_SEO_DIR . 'includes/class-ai-faq.php');
miro_safe_init_class('\Miro_AI_SEO\AI_Faq', null);

miro_safe_require(MIRO_AI_SEO_DIR . 'includes/class-ai-faq-ui.php');
miro_safe_init_class('\Miro_AI_SEO\AI_Faq_UI', null);

// Centralized menus (so Admin doesn't add a second top-level)
add_filter('miro/menus/centralized', '__return_true');

/* ----------------------------------------------------------------------------- 
 * Pages tab (Pro only; free = stub tab with Pro sentence)
 * --------------------------------------------------------------------------- */
if (!defined('MIRO_AI_SEO_IS_FREE') || !MIRO_AI_SEO_IS_FREE) {
    miro_safe_require(MIRO_AI_SEO_DIR . 'includes/modules/analytics/tabs/class-gsc-tab-pages.php');
    miro_safe_init_class('\Miro_AI_SEO\GSC_Tab_Pages', null);
}

/* ----------------------------------------------------------------------------- 
 * Core Admin + REST (load once, boot once)
 * --------------------------------------------------------------------------- */
miro_safe_require(MIRO_AI_SEO_DIR . 'includes/class-miro-admin.php');
miro_safe_require(MIRO_AI_SEO_DIR . 'includes/class-miro-rest.php');

add_action('plugins_loaded', function () {
    miro_safe_init_class('\Miro_AI_SEO\Admin', null);
    miro_safe_init_class('\Miro_AI_SEO\Rest',  null);
}, 0);

/* ----------------------------------------------------------------------------- 
 * Load reset utilities (Danger Zone handler) (safe)
 * --------------------------------------------------------------------------- */
add_action('plugins_loaded', function () {
    $utils = __DIR__ . '/includes/class-miro-admin-utils.php';
    if (miro_safe_require($utils)) {
        miro_safe_init_class('\\Miro_AI_SEO\\Miro_Admin_Utils', null, 'boot');
    }
}, 5);

/* ----------------------------------------------------------------------------- 
 * PREVENT DUPLICATE MENUS from other classes (run early)
 * --------------------------------------------------------------------------- */
add_action('admin_menu', function () {
    remove_action('admin_menu', ['Miro_AI_SEO\Admin', 'add_menu']);
    remove_action('admin_menu', ['Miro_AI_SEO\Miro_AI_Keyword_Lab', 'menu']);
}, 5);

/* ----------------------------------------------------------------------------- 
 * Redirect pretty /wp-admin/<slug> → admin.php?page=<slug>
 * CodeCanyon-safe: OFF by default (no admin hijack complaints)
 * --------------------------------------------------------------------------- */
add_action('admin_init', function () {

    if (!apply_filters('miro/enable_admin_slug_redirect', false)) return;

    if (defined('DOING_AJAX') && DOING_AJAX) return;
    if (!is_admin()) return;

    $uri = isset($_SERVER['REQUEST_URI']) ? sanitize_text_field(wp_unslash($_SERVER['REQUEST_URI'])) : '';
    if ($uri === '') return;

    $path = wp_parse_url($uri, PHP_URL_PATH);
    if (!$path) return;

    if (!preg_match('~^/wp-admin/([^/]+)$~', $path, $m)) return;

    $slug = $m[1];

    if (in_array($slug, ['admin.php','admin-ajax.php','index.php','options.php'], true)) return;

    $map = [
        'miro-rt-dashboard'    => 'miro-rt-dashboard',
        'miro-ai-keyword-lab'  => 'miro-ai-keyword-lab',
        'miro-ai-settings'     => 'miro-ai-settings',
        'miro-ai-trends'       => 'miro-ai-trends',
        'miro-gsc-analytics'   => 'miro-gsc-analytics',
    ];

    if (!isset($map[$slug])) return;

    // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Read-only comparison for redirect logic.
    if (isset($_GET['page']) && sanitize_key((string)wp_unslash($_GET['page'])) === (string)$map[$slug]) return;

    wp_safe_redirect(admin_url('admin.php?page=' . rawurlencode($map[$slug])));
    exit;
}, 1);

/* ----------------------------------------------------------------------------- 
 * AI Content Suite, AI Keyword Lab, AI Post Generator (Pro only; free = upsell)
 * --------------------------------------------------------------------------- */
if (!defined('MIRO_AI_SEO_IS_FREE') || !MIRO_AI_SEO_IS_FREE) {
$miro_ai_suite_file = MIRO_AI_SEO_DIR . 'includes/modules/ai-suite/class-ai-suite.php';
if (miro_safe_require($miro_ai_suite_file)) {
    miro_safe_init_class('\Miro_AI_SEO\AI_Suite', null);
} else {
    add_action('admin_notices', function(){
        echo '<div class="notice notice-error"><p><strong>Miro AI SEO:</strong> AI Suite module missing at <code>includes/modules/ai-suite/class-ai-suite.php</code>.</p></div>';
    });
}
$miro_ai_keyword_lab_file = MIRO_AI_SEO_DIR . 'includes/modules/ai-keyword-lab/class-miro-ai-keyword-lab.php';
if (miro_safe_require($miro_ai_keyword_lab_file)) {
    miro_safe_init_class('\Miro_AI_SEO\Miro_AI_Keyword_Lab', null);
} else {
    add_action('admin_notices', function(){
        echo '<div class="notice notice-error"><p><strong>Miro AI SEO:</strong> AI Keyword Lab module is missing at <code>includes/modules/ai-keyword-lab/class-miro-ai-keyword-lab.php</code>.</p></div>';
    });
}
$miro_ai_post_gen_file = MIRO_AI_SEO_DIR . 'includes/modules/ai-post-generator/class-miro-ai-post-generator.php';
if (miro_safe_require($miro_ai_post_gen_file)) {
    miro_safe_init_class('\Miro_AI_SEO\Miro_AI_Post_Generator', null);
} else {
    add_action('admin_notices', function(){
        echo '<div class="notice notice-error"><p><strong>Miro AI SEO:</strong> AI Post Generator module missing at <code>includes/modules/ai-post-generator/class-miro-ai-post-generator.php</code>.</p></div>';
    });
}
}

/* ----------------------------------------------------------------------------- 
 * Index Monitor (safe load)
 * --------------------------------------------------------------------------- */
add_filter('miro_main_menu_slug', function(){ return 'miro-ai-seo'; });

$miro_index_monitor_file = MIRO_AI_SEO_DIR . 'includes/modules/index-monitor/class-miro-index-monitor.php';
if (miro_safe_require($miro_index_monitor_file)) {
    miro_safe_init_class('\Miro_AI_SEO\Miro_Index_Monitor', null);
} else {
    add_action('admin_notices', function(){
        echo '<div class="notice notice-error"><p><strong>Miro AI SEO:</strong> Index Monitor module is missing at <code>includes/modules/index-monitor/class-miro-index-monitor.php</code>.</p></div>';
    });
}

/* ----------------------------------------------------------------------------- 
 * Internal Links (Pro only; free = upsell)
 * --------------------------------------------------------------------------- */
if (!defined('MIRO_AI_SEO_IS_FREE') || !MIRO_AI_SEO_IS_FREE) {
$miro_il_file = MIRO_AI_SEO_DIR . 'includes/modules/internal-links/class-miro-internal-links.php';
if (miro_safe_require($miro_il_file)) {
    miro_safe_init_class('\Miro_AI_SEO\Miro_Internal_Links', null);
}
}

/* -----------------------------------------------------------------------------
 * Services / Core includes (safe). Trends = Pro only.
 * --------------------------------------------------------------------------- */
miro_safe_require(MIRO_AI_SEO_DIR . 'includes/services/class-miro-embeddings.php');
if (!defined('MIRO_AI_SEO_IS_FREE') || !MIRO_AI_SEO_IS_FREE) {
    miro_safe_require(MIRO_AI_SEO_DIR . 'includes/class-miro-trends.php');
}

//
// ALT Fix (safe load + safe init)  ✅ FIXED
//
$miro_alt_admin = MIRO_AI_SEO_DIR . 'includes/admin/class-miro-alt-fix.php';
$miro_alt_rest  = MIRO_AI_SEO_DIR . 'includes/rest/class-miro-rest-alt-fix.php';
miro_safe_require($miro_alt_admin);
miro_safe_require($miro_alt_rest);

miro_safe_init_class('\Miro_AI_SEO\Miro_Alt_Fix_Admin', 'Miro_Alt_Fix_Admin');
miro_safe_init_class('\Miro_AI_SEO\Miro_REST_Alt_Fix',  'Miro_REST_Alt_Fix');

//
// 404 Monitor + Redirections (safe load + safe init)
//
miro_safe_require(__DIR__ . '/includes/class-miro-404-monitor.php');
miro_safe_init_class('\Miro_AI_SEO\Miro_404_Monitor', null);

miro_safe_require(__DIR__ . '/includes/class-miro-redirections.php');
miro_safe_init_class('\Miro_AI_SEO\Miro_Redirections', null);

/* -----------------------------------------------------------------------------
 * Reports (Pro only; free = upsell)
 * --------------------------------------------------------------------------- */
if (!defined('MIRO_AI_SEO_IS_FREE') || !MIRO_AI_SEO_IS_FREE) {
$miro_reports_file = MIRO_AI_SEO_DIR . 'includes/modules/reports/class-miro-reports.php';
if (miro_safe_require($miro_reports_file)) {
    miro_safe_init_class('\Miro_AI_SEO\Miro_Reports', null);
} else {
    add_action('admin_notices', function () {
        echo '<div class="notice notice-error"><p><strong>Miro AI SEO:</strong> Reports module missing at <code>includes/modules/reports/class-miro-reports.php</code>.</p></div>';
    });
}
}

/* -----------------------------------------------------------------------------
 * SEO Hub (Local SEO, Schema, Broken Links, Breadcrumbs, OG/Twitter, Sitemap, Canonical)
 * --------------------------------------------------------------------------- */
$miro_seo_hub_file = MIRO_AI_SEO_DIR . 'includes/modules/seo-hub/class-miro-seo-hub.php';
    if (miro_safe_require($miro_seo_hub_file)) {
        miro_safe_init_class('\Miro_AI_SEO\Miro_SEO_Hub', null);
        $miro_seo_hub_local_file = MIRO_AI_SEO_DIR . 'includes/modules/seo-hub/class-seo-hub-local-seo.php';
        if (miro_safe_require($miro_seo_hub_local_file)) {
            miro_safe_init_class('\Miro_AI_SEO\SEO_Hub_Local_SEO', null);
        }
        $miro_seo_hub_schema_file = MIRO_AI_SEO_DIR . 'includes/modules/seo-hub/class-seo-hub-schema.php';
        if (miro_safe_require($miro_seo_hub_schema_file)) {
            miro_safe_init_class('\Miro_AI_SEO\SEO_Hub_Schema', null);
        }
        $miro_seo_hub_broken_file = MIRO_AI_SEO_DIR . 'includes/modules/seo-hub/class-seo-hub-broken-links.php';
        if (miro_safe_require($miro_seo_hub_broken_file)) {
            miro_safe_init_class('\Miro_AI_SEO\SEO_Hub_Broken_Links', null);
        }
        $miro_seo_hub_breadcrumbs_file = MIRO_AI_SEO_DIR . 'includes/modules/seo-hub/class-seo-hub-breadcrumbs.php';
        if (miro_safe_require($miro_seo_hub_breadcrumbs_file)) {
            miro_safe_init_class('\Miro_AI_SEO\SEO_Hub_Breadcrumbs', null);
        }
        $miro_seo_hub_og_twitter_file = MIRO_AI_SEO_DIR . 'includes/modules/seo-hub/class-seo-hub-og-twitter.php';
        if (miro_safe_require($miro_seo_hub_og_twitter_file)) {
            miro_safe_init_class('\Miro_AI_SEO\SEO_Hub_OG_Twitter', null);
        }
        $miro_seo_hub_sitemap_file = MIRO_AI_SEO_DIR . 'includes/modules/seo-hub/class-seo-hub-sitemap.php';
        if (miro_safe_require($miro_seo_hub_sitemap_file)) {
            miro_safe_init_class('\Miro_AI_SEO\SEO_Hub_Sitemap', null);
        }
    } else {
    add_action('admin_notices', function () {
        echo '<div class="notice notice-error"><p><strong>Miro AI SEO:</strong> SEO Hub module missing at <code>includes/modules/seo-hub/class-miro-seo-hub.php</code>.</p></div>';
    });
}

//
// AI Fix (single-post) always; AI Fix Bulk = Pro only
//
miro_safe_require(MIRO_AI_SEO_DIR . 'includes/admin/class-miro-ai-fix.php');
miro_safe_init_class('\Miro_AI_SEO\AI_Fix', null);

if (!defined('MIRO_AI_SEO_IS_FREE') || !MIRO_AI_SEO_IS_FREE) {
    miro_safe_require(MIRO_AI_SEO_DIR . 'includes/admin/class-miro-ai-fix-bulk.php');
    miro_safe_init_class('\Miro_AI_SEO\AI_Fix_Bulk', null);
}

/* ----------------------------------------------------------------------------- 
 * Gutenberg meta for focus keyword
 * --------------------------------------------------------------------------- */
add_action('init', function () {
    $types = get_post_types(['public' => true], 'names');
    foreach ($types as $pt) {
        register_post_meta($pt, 'miro_focus_keyword', [
            'show_in_rest'      => true,
            'single'            => true,
            'type'              => 'string',
            'sanitize_callback' => 'sanitize_text_field',
            'auth_callback'     => function () { return current_user_can('edit_posts'); },
        ]);
    }
});

/* ----------------------------------------------------------------------------- 
 * Schema boot — disabled (kept as you had)
 * --------------------------------------------------------------------------- */
/*
add_action('init', function(){
    \MiroAI\Schema\Module::init();
});
add_action('wp_head', function(){
    \MiroAI\Schema\Module::print_jsonld_for_the_loop();
}, 99);
*/

/* ----------------------------------------------------------------------------- 
 * Trends (Pro only; free = upsell)
 * --------------------------------------------------------------------------- */
if (!defined('MIRO_AI_SEO_IS_FREE') || !MIRO_AI_SEO_IS_FREE) {
    miro_safe_init_class('\Miro_AI_SEO\Trends', null);
}

/* ----------------------------------------------------------------------------- 
 * Cron: Hourly + Daily (use main plugin file for hooks when free)
 * --------------------------------------------------------------------------- */
$miro_plugin_file = (defined('MIRO_AI_MAIN_FILE') ? MIRO_AI_MAIN_FILE : (defined('MIRO_AI_SEO_FILE') ? MIRO_AI_SEO_FILE : __FILE__));
register_activation_hook($miro_plugin_file, function () {

    flush_rewrite_rules(false);

    if (!wp_next_scheduled('miro_ai_seo_hourly_sync')) {
        wp_schedule_event(time() + 300, 'hourly', 'miro_ai_seo_hourly_sync');
    }
    if (!wp_next_scheduled('miro_daily_sync')) {
        wp_schedule_event(time() + 600, 'daily', 'miro_daily_sync');
    }
});

register_deactivation_hook($miro_plugin_file, function () {
    flush_rewrite_rules(false);
    $t1 = wp_next_scheduled('miro_ai_seo_hourly_sync');
    if ($t1) wp_unschedule_event($t1, 'miro_ai_seo_hourly_sync');
    $t2 = wp_next_scheduled('miro_daily_sync');
    if ($t2) wp_unschedule_event($t2, 'miro_daily_sync');
});

add_action('miro_ai_seo_hourly_sync', function() {
    $log = get_option('miro_ai_seo_sync_log', []);
    if (!is_array($log)) $log = [];
    $log[] = [
        'ts' => current_time('mysql'),
        'note' => 'Hourly sync tick (mock).'
    ];
    update_option('miro_ai_seo_sync_log', $log);
});

add_action('miro_daily_sync', function(){
    if (class_exists('\Miro_AI_SEO\Miro_Index_Monitor')) {
        \Miro_AI_SEO\Miro_Index_Monitor::cron_daily_batch();
    }
});

/* ----------------------------------------------------------------------------- 
 * Helper: add_submenu_once (prevents accidental dupes)
 * --------------------------------------------------------------------------- */
if (!function_exists('miro_ai_add_submenu_once')) {
    function miro_ai_add_submenu_once($parent_slug, $page_title, $menu_title, $cap, $menu_slug, $callback, $position = null) {
        static $added = [];
        if (isset($added[$menu_slug])) return;
        $added[$menu_slug] = true;

        global $submenu;
        if (!empty($submenu[$parent_slug])) {
            foreach ($submenu[$parent_slug] as $item) {
                if (!empty($item[2]) && $item[2] === $menu_slug) return;
            }
        }
        add_submenu_page($parent_slug, $page_title, $menu_title, $cap, $menu_slug, $callback, $position);
    }
}

/* ----------------------------------------------------------------------------- 
 * Admin Menu — SINGLE source of truth (Reorganized for clarity)
 * --------------------------------------------------------------------------- */
add_action('admin_menu', function () {
    $parent_slug = 'miro-ai-seo';

    // Top-level once
    global $menu;
    $top_exists = false;
    if (is_array($menu)) {
        foreach ($menu as $m) {
            if (!empty($m[2]) && $m[2] === $parent_slug) { $top_exists = true; break; }
        }
    }

    if (!$top_exists) {
        add_menu_page(
            'Miro AI SEO',
            'Miro AI SEO',
            miro_ai_cap(),
            $parent_slug,
            'miro_ai_admin_page',
            'dashicons-chart-line',
            60
        );
    }

    // Hide auto "Overview" row
    remove_submenu_page($parent_slug, $parent_slug);

    // Dashboard as first submenu item (links to main page)
    miro_ai_add_submenu_once(
        $parent_slug,
        'Dashboard',
        'Dashboard',
        miro_ai_cap(),
        $parent_slug,
        'miro_ai_admin_page',
        5
    );

    // ============================================================================
    // TOP – Core & Daily Use
    // ============================================================================
    // Note: Google Search Console and GSC Analytics are registered by their own classes
    // at positions 10-11 (see below for position assignments)

    // Trend Finder, AI Keyword Lab, AI Content Suite, AI Fix Bulk: Pro only (free = upsell pages)
    if (!defined('MIRO_AI_SEO_IS_FREE') || !MIRO_AI_SEO_IS_FREE) {
    miro_ai_add_submenu_once(
        $parent_slug,
        'Trend Finder',
        'Trend Finder',
        miro_ai_cap(),
        'miro-ai-trends',
        ['Miro_AI_SEO\Admin', 'render_trends'],
        13
    );
    miro_ai_add_submenu_once(
        $parent_slug,
        'AI Keyword Lab',
        'AI Keyword Lab',
        miro_ai_cap(),
        'miro-ai-keyword-lab',
        ['Miro_AI_SEO\Miro_AI_Keyword_Lab', 'render_page'],
        20
    );
    miro_ai_add_submenu_once(
        $parent_slug,
        'AI Content Suite',
        'AI Content Suite',
        miro_ai_cap(),
        'miro-ai-suite',
        ['Miro_AI_SEO\AI_Suite', 'render'],
        21
    );
    }

    // AI Fix (Bulk) - registered by its own class at position 22 (Pro only)

    // ============================================================================
    // SEO & Technical Tools
    // ============================================================================
    // Internal Links, Redirections, Index Monitor, 404 Monitor
    // Registered by their own classes at positions 30-33

    // ============================================================================
    // Optimization & Fixes
    // ============================================================================
    // ALT Fix, Fix Center
    // Registered by their own classes at positions 40-41

    // ============================================================================
    // BOTTOM – Settings
    // ============================================================================
        miro_ai_add_submenu_once(
            $parent_slug,
            'Settings',
            'Settings',
            miro_ai_cap(),
            'miro-ai-settings',
            ['Miro_AI_SEO\Admin', 'render_settings'],
            50
        );
}, 9);

/* ----------------------------------------------------------------------------- 
 * Force menu order: Dashboard, GSC, then all AI items grouped, then rest
 * --------------------------------------------------------------------------- */
add_action('admin_menu', function () {
    global $submenu;
    $parent = 'miro-ai-seo';
    if (empty($submenu[$parent]) || !is_array($submenu[$parent])) return;

    $dashboard = null;
    $gsc = null;
    $analytics = null;
    $reports = null;
    $settings = null;
    $ai_items = [];
    $rest = [];
    foreach ($submenu[$parent] as $item) {
        $slug = isset($item[2]) ? $item[2] : '';
        $title = isset($item[0]) ? (string) $item[0] : '';
        if ($slug === $parent) $dashboard = $item;
        elseif ($slug === 'miro-gsc') $gsc = $item;
        elseif ($slug === 'miro-gsc-analytics') $analytics = $item;
        elseif ($slug === 'miro-reports') $reports = $item;
        elseif ($slug === 'miro-ai-settings') $settings = $item;
        elseif (strpos($title, 'AI ') === 0 || strpos($slug, 'miro-ai-') === 0) $ai_items[] = $item;
        else $rest[] = $item;
    }
    $ordered = [];
    if ($dashboard) $ordered[] = $dashboard;
    if ($gsc) $ordered[] = $gsc;
    if ($analytics) $ordered[] = $analytics;
    $ordered = array_merge($ordered, $ai_items, $rest);
    if ($reports) $ordered[] = $reports;
    if ($settings) $ordered[] = $settings;
    if (!empty($ordered)) {
        $submenu[$parent] = $ordered;
    }
}, 999);

/* ----------------------------------------------------------------------------- 
 * GSC Connect (safe load + init)
 * --------------------------------------------------------------------------- */
$miro_gsc_connect = MIRO_AI_SEO_DIR . 'includes/modules/gsc/class-miro-gsc-connect.php';
if (miro_safe_require($miro_gsc_connect)) {
    miro_safe_init_class('\Miro_AI_SEO\Miro_GSC_Connect', null);
} else {
    add_action('admin_notices', function () {
        echo '<div class="notice notice-error"><p><strong>Miro AI SEO:</strong> Missing file <code>includes/modules/gsc/class-miro-gsc-connect.php</code>.</p></div>';
    });
}

/* ----------------------------------------------------------------------------- 
 * GSC Analytics (core + tabs). Free: Overview + Keywords + pro-tab stubs only.
 * --------------------------------------------------------------------------- */
$miro_gsc_core       = MIRO_AI_SEO_DIR . 'includes/modules/analytics/gsc-analytics.php';
$miro_tab_over       = MIRO_AI_SEO_DIR . 'includes/modules/analytics/tabs/class-gsc-tab-overview.php';
$miro_tab_kw         = MIRO_AI_SEO_DIR . 'includes/modules/analytics/tabs/class-gsc-tab-keywords.php';

if (defined('MIRO_AI_SEO_IS_FREE') && MIRO_AI_SEO_IS_FREE) {
    // Free: load GSC core + Overview + Keywords + pro-tabs stub (same tab names, upsell content)
    foreach ([$miro_gsc_core, $miro_tab_over, $miro_tab_kw] as $miro_tab_file) {
        if (!miro_safe_require($miro_tab_file)) {
            add_action('admin_notices', function() use ($miro_tab_file){
                echo '<div class="notice notice-error"><p><strong>Miro AI SEO:</strong> Missing file <code>'
                     . esc_html(str_replace(ABSPATH,"",$miro_tab_file)) . '</code>.</p></div>';
            });
        }
    }
    $miro_gsc_pro_tabs = MIRO_AI_SEO_DIR . 'includes/modules/analytics/class-miro-gsc-pro-tabs.php';
    if (file_exists($miro_gsc_pro_tabs)) {
        require_once $miro_gsc_pro_tabs;
        \Miro_AI_SEO\Miro_GSC_Pro_Tabs::init();
    }
    miro_safe_init_class('\Miro_AI_SEO\GSC_Tab_Overview', null);
    miro_safe_init_class('\Miro_AI_SEO\GSC_Tab_Keywords', null);
    miro_safe_init_class('\Miro_AI_SEO\GSC_Analytics_Core', null);
} else {
    $miro_tab_rank       = MIRO_AI_SEO_DIR . 'includes/modules/analytics/tabs/class-gsc-tab-rank.php';
    $miro_tab_ai         = MIRO_AI_SEO_DIR . 'includes/modules/analytics/tabs/class-gsc-tab-ai.php';
    $miro_tab_rank_today = MIRO_AI_SEO_DIR . 'includes/modules/analytics/tabs/class-gsc-tab-rank-today.php';
    $miro_tab_qw         = MIRO_AI_SEO_DIR . 'includes/modules/analytics/tabs/class-gsc-tab-quickwins.php';
    $miro_tab_gap        = MIRO_AI_SEO_DIR . 'includes/modules/analytics/tabs/class-miro-analytics-gap.php';
    $miro_tab_rankflow   = MIRO_AI_SEO_DIR . 'includes/modules/analytics/tabs/class-gsc-tab-rankflow.php';
    $miro_tab_easy       = MIRO_AI_SEO_DIR . 'includes/modules/analytics/tabs/class-gsc-tab-easy-keywords.php';
    $miro_tab_presence   = MIRO_AI_SEO_DIR . 'includes/modules/analytics/tabs/class-gsc-tab-presence.php';
    miro_safe_require(MIRO_AI_SEO_DIR . 'includes/modules/rankflow/class-rankflow-snapshot.php');
    miro_safe_init_class('\Miro_AI_SEO\RankFlow_Snapshot', null);
    foreach ([$miro_gsc_core, $miro_tab_over, $miro_tab_kw, $miro_tab_easy, $miro_tab_rank, $miro_tab_ai, $miro_tab_qw, $miro_tab_gap, $miro_tab_presence, $miro_tab_rank_today, $miro_tab_rankflow] as $miro_tab_file) {
        if (!miro_safe_require($miro_tab_file)) {
            add_action('admin_notices', function() use ($miro_tab_file){
                echo '<div class="notice notice-error"><p><strong>Miro AI SEO:</strong> Missing file <code>'
                     . esc_html(str_replace(ABSPATH,"",$miro_tab_file)) . '</code>.</p></div>';
            });
        }
    }
    miro_safe_init_class('\Miro_AI_SEO\GSC_Tab_Overview', null);
    miro_safe_init_class('\Miro_AI_SEO\GSC_Tab_Keywords', null);
    miro_safe_init_class('\Miro_AI_SEO\GSC_Tab_Easy_Keywords', null);
    miro_safe_init_class('\Miro_AI_SEO\GSC_Tab_Rank', null);
    miro_safe_init_class('\Miro_AI_SEO\GSC_Tab_AI', null);
    miro_safe_init_class('\Miro_AI_SEO\GSC_Tab_QuickWins', null);
    miro_safe_init_class('\Miro_AI_SEO\Miro_Analytics_Content_Gap', null);
    miro_safe_init_class('\Miro_AI_SEO\GSC_Tab_Presence', null);
    miro_safe_init_class('\Miro_AI_SEO\GSC_Tab_Rank_Today', null);
    miro_safe_init_class('\Miro_AI_SEO\GSC_Tab_RankFlow', null);
    miro_safe_init_class('\Miro_AI_SEO\GSC_Analytics_Core', null);
}

/* ----------------------------------------------------------------------------- 
 * Simple Dashboard (adds link to Analytics)
 * --------------------------------------------------------------------------- */
if (!function_exists('miro_ai_admin_page')) {
    function miro_ai_admin_page() {
        if (function_exists('miro_ai_cap') && !current_user_can(\miro_ai_cap())) {
            wp_die(esc_html__('You do not have permission to perform this action.', 'miro-ai-seo'), '', ['response' => 403]);
        }

        $af_logo = defined('MIRO_AI_SEO_URL') ? MIRO_AI_SEO_URL . 'assets/img/miro-logo.webp' : '';
        
        // Get basic stats
        $published_posts = wp_count_posts('post')->publish ?? 0;
        $published_pages = wp_count_posts('page')->publish ?? 0;
        $total_posts = $published_posts + $published_pages;
        
        // GSC stats (if available)
        $gsc_stats = [
            'clicks' => 0,
            'impressions' => 0,
            'keywords' => 0,
            'ctr' => 0.0,
            'position' => 0.0,
            'last_synced' => '—',
        ];
        $gsc_connected = false;
        if (class_exists('\Miro_AI_SEO\GSC_Analytics_Core')) {
            $gsc_meta = get_option('miro_gsc_meta', []);
            if (!empty($gsc_meta['access_token'])) {
                $gsc_connected = true;
                $rest_base = site_url('index.php');
                $gsc_rest_url = add_query_arg([
                    'rest_route' => '/miro/v1/analytics/ui/snapshot',
                    'days' => 30,
                ], $rest_base);
                $gsc_response = wp_remote_get($gsc_rest_url, [
                    'headers' => ['X-WP-Nonce' => wp_create_nonce('wp_rest')],
                    'timeout' => 10,
                ]);
                if (!is_wp_error($gsc_response) && wp_remote_retrieve_response_code($gsc_response) === 200) {
                    $gsc_data = json_decode(wp_remote_retrieve_body($gsc_response), true);
                    if (is_array($gsc_data) && isset($gsc_data['kpis'])) {
                        $gsc_stats = array_merge($gsc_stats, $gsc_data['kpis']);
                    }
                }
            }
        }

        echo '<div class="wrap">';
        echo '<h1 class="wp-heading-inline">Dashboard</h1>';
        echo '</div>';

        echo '<div class="miro-alt-wrap miro-dashboard-wrap">';

        // HERO (matches Fix Center style)
        echo '<div class="af-hero">';
        echo '<div class="af-hero-pill">';
        echo '<div class="af-hero-pill-inner">';
        if (!empty($af_logo)) {
            echo '<img src="' . esc_url($af_logo) . '" alt="' . esc_attr__('Miro AI SEO logo', 'miro-ai-seo') . '">';
        } else {
            echo '<div class="af-hero-pill-fallback">MIRO</div>';
        }
        echo '</div>';
        echo '</div>';

        echo '<div class="af-hero-main">';
        echo '<div class="af-hero-title-row">';
        echo '<div class="af-hero-title">SEO Performance Overview</div>';
        echo '<span class="af-hero-tag">Dashboard</span>';
        echo '</div>';

        echo '<p class="af-hero-sub">';
        echo 'Monitor your site\'s SEO health, track rankings, and discover opportunities to grow organic traffic.';
        echo '</p>';

        echo '<div class="af-hero-chips">';
        echo '<div class="af-chip af-chip-pro af-chip-alt">Analytics<span class="af-chip-sub">GSC integration</span></div>';
        echo '<div class="af-chip af-chip-pro af-chip-scan">AI Tools<span class="af-chip-sub">Content & keywords</span></div>';
        echo '<div class="af-chip af-chip-pro af-chip-safe">Optimization<span class="af-chip-sub">Links & fixes</span></div>';
        echo '</div>';

        echo '</div>';

        echo '<div class="af-hero-metrics">';
        echo '<div class="af-tip-title">';
        echo '<span class="af-tip-ico">📊</span>';
        echo '<span>Quick Stats</span>';
        echo '</div>';
        echo '<div class="af-tip-sub">';
        echo number_format($total_posts) . ' published posts & pages';
        if ($gsc_connected) {
            echo ' • ' . number_format($gsc_stats['clicks']) . ' clicks (30d)';
        }
        echo '</div>';
        echo '</div>';
        echo '</div>';

        // STATS CARDS
        echo '<div class="af-card" style="margin-bottom: 16px;">';
        echo '<div style="font-size: 14px; font-weight: 600; margin-bottom: 12px; color: #111827;">Performance Metrics</div>';
        echo '<div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 12px;">';
        
        // GSC Stats Card
        if ($gsc_connected) {
            echo '<div class="af-box" style="padding: 12px;">';
            echo '<small style="display: block; color: #6b7280; font-size: 11px; margin-bottom: 4px;">Search Traffic</small>';
            echo '<strong style="display: block; font-size: 20px; color: #111827;">' . number_format($gsc_stats['clicks']) . '</strong>';
            echo '<div style="font-size: 12px; color: #6b7280; margin-top: 4px;">' . number_format($gsc_stats['impressions']) . ' impressions</div>';
            echo '</div>';
            
            echo '<div class="af-box" style="padding: 12px;">';
            echo '<small style="display: block; color: #6b7280; font-size: 11px; margin-bottom: 4px;">Keywords</small>';
            echo '<strong style="display: block; font-size: 20px; color: #111827;">' . number_format($gsc_stats['keywords']) . '</strong>';
            echo '<div style="font-size: 12px; color: #6b7280; margin-top: 4px;">Top 100 positions</div>';
            echo '</div>';
            
            echo '<div class="af-box" style="padding: 12px;">';
            echo '<small style="display: block; color: #6b7280; font-size: 11px; margin-bottom: 4px;">Avg CTR</small>';
            echo '<strong style="display: block; font-size: 20px; color: #111827;">' . number_format($gsc_stats['ctr'], 2) . '%</strong>';
            echo '<div style="font-size: 12px; color: #6b7280; margin-top: 4px;">Click-through rate</div>';
            echo '</div>';
            
            echo '<div class="af-box" style="padding: 12px;">';
            echo '<small style="display: block; color: #6b7280; font-size: 11px; margin-bottom: 4px;">Avg Position</small>';
            echo '<strong style="display: block; font-size: 20px; color: #111827;">' . number_format($gsc_stats['position'], 1) . '</strong>';
            echo '<div style="font-size: 12px; color: #6b7280; margin-top: 4px;">Lower is better</div>';
            echo '</div>';
        } else {
            echo '<div class="af-box" style="padding: 12px; grid-column: 1 / -1;">';
            echo '<div style="font-size: 13px; color: #6b7280;">';
            echo '<strong style="color: #111827;">Google Search Console not connected.</strong> ';
            echo '<a href="' . esc_url(admin_url('admin.php?page=miro-gsc')) . '" style="color: #2271b1; text-decoration: none;">Connect GSC</a> to see performance metrics.';
            echo '</div>';
            echo '</div>';
        }
        
        echo '</div>';
        echo '</div>';

        // CONTENT STATS
        echo '<div class="af-card" style="margin-bottom: 16px;">';
        echo '<div style="font-size: 14px; font-weight: 600; margin-bottom: 12px; color: #111827;">Content</div>';
        echo '<div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 12px;">';
        
        echo '<div class="af-box" style="padding: 12px;">';
        echo '<small style="display: block; color: #6b7280; font-size: 11px; margin-bottom: 4px;">Published Content</small>';
        echo '<strong style="display: block; font-size: 20px; color: #111827;">' . number_format($total_posts) . '</strong>';
        echo '<div style="font-size: 12px; color: #6b7280; margin-top: 4px;">' . number_format($published_posts) . ' posts, ' . number_format($published_pages) . ' pages</div>';
        echo '</div>';
        
        echo '</div>';
        echo '</div>';

        // QUICK LINKS — all modules grouped by category
        echo '<div class="af-card miro-dashboard-quick-access">';
        echo '<div class="miro-dashboard-quick-title">Quick Access</div>';
        
        $sections = [
            'Analytics & Reports' => [
                ['url' => 'miro-gsc', 'title' => 'Google Search Console', 'desc' => 'Connect GSC & manage properties'],
                ['url' => 'miro-gsc-analytics', 'title' => 'GSC Analytics', 'desc' => 'Overview, keywords, rank tracking'],
                ['url' => 'miro-reports', 'title' => 'Reports', 'desc' => 'Scheduled reports & keyword alerts'],
            ],
            'SEO & Technical' => [
                ['url' => 'miro-seo-hub', 'title' => 'SEO Hub', 'desc' => 'Local SEO, Schema, Breadcrumbs, Sitemap & more'],
                ['url' => 'miro-redirections', 'title' => 'Redirections', 'desc' => 'Manage 301, 302, and 410 redirects'],
                ['url' => 'miro-404-monitor', 'title' => '404 Monitor', 'desc' => 'Track and fix broken URLs'],
                ['url' => 'miro-index', 'title' => 'Index Monitor', 'desc' => 'GSC indexing status & coverage'],
                ['url' => 'miro-instant-index', 'title' => 'Instant Indexing', 'desc' => 'Submit URLs to IndexNow'],
            ],
            'AI & Content' => [
                ['url' => 'miro-ai-keyword-lab', 'title' => 'AI Keyword Lab', 'desc' => 'Discover & group keywords'],
                ['url' => 'miro-ai-suite', 'title' => 'AI Content Suite', 'desc' => 'Title, meta, content tools'],
                ['url' => 'miro-ai-post-generator', 'title' => 'AI Post Generator', 'desc' => 'Generate SEO-optimized posts'],
                ['url' => 'miro-ai-fix-bulk', 'title' => 'AI Fix (Bulk)', 'desc' => 'Bulk title & meta optimization'],
                ['url' => 'miro-ai-trends', 'title' => 'Trend Finder', 'desc' => 'Discover trending topics'],
            ],
            'Links & Fixes' => [
                ['url' => 'miro-ai-internal-links', 'title' => 'Internal Links', 'desc' => 'Suggest & manage links'],
                ['url' => 'miro-fix-center', 'title' => 'Fix Center', 'desc' => 'CTR optimization'],
                ['url' => 'miro-alt-fix', 'title' => 'ALT Fix', 'desc' => 'Image ALT text fixes'],
            ],
            'Settings' => [
                ['url' => 'miro-ai-settings', 'title' => 'Settings', 'desc' => 'Configuration & API keys'],
            ],
        ];
        
        foreach ($sections as $section_title => $links) {
            echo '<div class="miro-dashboard-quick-section">';
            echo '<div class="miro-dashboard-quick-section-title">' . esc_html($section_title) . '</div>';
            echo '<div class="miro-dashboard-quick-grid">';
            foreach ($links as $link) {
                echo '<a href="' . esc_url(admin_url('admin.php?page=' . $link['url'])) . '" class="miro-dashboard-quick-link af-box">';
                echo '<strong class="miro-dashboard-quick-link-title">' . esc_html($link['title']) . '</strong>';
                echo '<span class="miro-dashboard-quick-link-desc">' . esc_html($link['desc']) . '</span>';
                echo '</a>';
            }
            echo '</div>';
            echo '</div>';
        }
        
        echo '</div>';

        echo '</div>'; // .miro-alt-wrap
    }
}
