<?php
/**
 * Fired when the plugin is uninstalled.
 *
 * @package Miro_AI_SEO
 */

// If uninstall not called from WordPress, then exit.
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Delete all plugin options (only plugin-owned option names)
// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound -- Uninstall script; local scope.
$miro_options = [
    'miro_ai_openai_key',
    'miro_ai_gemini_key',
    'miro_ai_focus_language',
    'miro_ai_seo_sync_log',
    'miro_redirect_settings',
    'miro_redirect_rules',
    'miro_404_db_version',
    'miro_404_fallback_log',
    'miro_index_settings',
    'miro_index_backfill_state',
    'miro_gsc_settings',
    'miro_gsc_property',
    'miro_gsc_status',
    'miro_gsc_properties',
    'miro_gsc_site_series',
    'miro_gsc_last_queries',
    'miro_gsc_sync_status',
    'miro_gsc_sites_cache',
    'pp_miro_gsc_settings',
    'pp_miro_gsc_status',
    'pp_miro_gsc_property',
    'pp_miro_gsc_properties',
    'miro_rt_settings',
    'miro_rt_status',
    'miro_license',
    'miro_license_email',
    'miro_license_key',
    'miro_license_instance_id',
    'miro_license_status',
    'miro_license_last_check',
    'miro_license_last_error',
    'miro_license_token',
    'miro_license_token_exp',
    'miro_license_last_ok',
    'miro_broker_secret',
    'miro_site_id',
    'miro_instant_index_settings',
    'miro_il_index_version',
    'miro_il_graph_version',
    'miro_ilx_dbv',
    'miro_ilx_df',
];

foreach ($miro_options as $miro_option) {
    delete_option($miro_option);
}

// Delete all transients (safe: esc_like + prepare)
global $wpdb;
$miro_pattern1 = $wpdb->esc_like('_transient_miro_') . '%';
$miro_pattern2 = $wpdb->esc_like('_transient_timeout_miro_') . '%';
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching -- Uninstall: direct DB required; no caching for one-time cleanup.
$wpdb->query(
    $wpdb->prepare(
        "DELETE FROM {$wpdb->options} WHERE option_name LIKE %s OR option_name LIKE %s",
        $miro_pattern1,
        $miro_pattern2
    )
);

// Delete post meta
$miro_meta_keys = [
    'miro_focus_keyword',
    '_miro_index_status',
    '_miro_index_details',
    '_miro_index_last_check',
    '_miro_index_first_seen_notidx',
    '_miro_index_retry_count',
];

foreach ($miro_meta_keys as $miro_meta_key) {
    delete_post_meta_by_key($miro_meta_key);
}

// Drop plugin-owned tables only. Table names are fixed suffixes (whitelist), not user input.
$miro_table_suffixes = [
    'miro_404_log',
    'miro_rt_keywords',
    'miro_rt_snapshots',
    'miro_rt_competitors',
    'miro_ilx_index',
    'miro_ilx_edges',
    'ppmiro_index_log',
];

foreach ($miro_table_suffixes as $miro_suffix) {
    $miro_table = $wpdb->prefix . $miro_suffix;
    // phpcs:ignore WordPress.DB.PreparedSQL.InterpolatedNotPrepared, WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.SchemaChange -- Uninstall: table from whitelist; direct DROP required.
    $wpdb->query("DROP TABLE IF EXISTS `{$miro_table}`");
}

// Clear scheduled hooks
$miro_hooks = [
    'miro_ai_seo_hourly_sync',
    'miro_daily_sync',
    'miro_index_monitor_daily',
    'miro_license_daily',
    'miro_rt_hourly',
    'miro_ii_tick_5min',
];

foreach ($miro_hooks as $miro_hook) {
    $miro_timestamp = wp_next_scheduled($miro_hook);
    if ($miro_timestamp) {
        wp_unschedule_event($miro_timestamp, $miro_hook);
    }
    wp_clear_scheduled_hook($miro_hook);
}

// Note: Do NOT flush rewrite rules on uninstall (WordPress best practice)
